/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.control;

import dev.xylonity.bonsai.ghosts.common.entity.MainGhostEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;

public class GhostMoveControl
extends MoveControl {
    private final MainGhostEntity ghost;

    public GhostMoveControl(MainGhostEntity ghost) {
        super((Mob)ghost);
        this.ghost = ghost;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            Vec3 v = new Vec3(this.wantedX - this.ghost.getX(), this.wantedY - this.ghost.getY(), this.wantedZ - this.ghost.getZ());
            double dist = v.length();
            if (dist < this.ghost.getBoundingBox().getSize()) {
                this.operation = MoveControl.Operation.WAIT;
                this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().scale(0.5));
            } else {
                this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().add(v.scale(this.speedModifier * 0.05 / dist)));
                if (this.ghost.getTarget() == null) {
                    Vec3 to = this.ghost.getDeltaMovement();
                    this.ghost.setYRot(-((float)Mth.atan2((double)to.x, (double)to.z)) * 57.295776f);
                } else {
                    double x = this.ghost.getTarget().getX() - this.ghost.getX();
                    double z = this.ghost.getTarget().getZ() - this.ghost.getZ();
                    this.ghost.setYRot(-((float)Mth.atan2((double)x, (double)z)) * 57.295776f);
                }
                this.ghost.yBodyRot = this.ghost.getYRot();
            }
        }
    }
}

