/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.MainGhostEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GhostApproachHeldGlowBerriesGoal
extends Goal {
    private final MainGhostEntity ghost;
    private final double maxSpeed;
    private final double minDistance;
    private final double startDistance;
    private final float lerpFactor;
    private final int searchRadius;
    private Player target;
    private boolean forcedNoPhysics = false;

    public GhostApproachHeldGlowBerriesGoal(MainGhostEntity ghost, double maxSpeed, double minDistance, double startDistance, float lerpFactor, int searchRadius) {
        this.ghost = ghost;
        this.maxSpeed = maxSpeed;
        this.minDistance = minDistance;
        this.startDistance = startDistance;
        this.lerpFactor = lerpFactor;
        this.searchRadius = searchRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.ghost.isTame()) {
            return false;
        }
        if (this.ghost.isVehicle() || this.ghost.isInSittingPose()) {
            return false;
        }
        List players = this.ghost.level().getEntitiesOfClass(Player.class, this.ghost.getBoundingBox().inflate((double)this.searchRadius), p -> p.isAlive() && !p.isSpectator() && (p.getMainHandItem().is(Items.GLOW_BERRIES) || p.getOffhandItem().is(Items.GLOW_BERRIES)));
        if (players.isEmpty()) {
            return false;
        }
        this.target = players.stream().min(Comparator.comparingDouble(p -> p.distanceToSqr((Entity)this.ghost))).orElse(null);
        return true;
    }

    public boolean canContinueToUse() {
        if (this.target == null) {
            return false;
        }
        if (this.ghost.isTame()) {
            return false;
        }
        if (this.ghost.isVehicle() || this.ghost.isInSittingPose()) {
            return false;
        }
        if (!this.target.isAlive()) {
            return false;
        }
        if (this.target.distanceToSqr((Entity)this.ghost) > (double)(this.searchRadius * this.searchRadius)) {
            return false;
        }
        return this.target.getMainHandItem().is(Items.GLOW_BERRIES) || this.target.getOffhandItem().is(Items.GLOW_BERRIES);
    }

    public void start() {
        this.forcedNoPhysics = false;
    }

    public void stop() {
        if (this.forcedNoPhysics) {
            this.ghost.noPhysics = false;
            this.forcedNoPhysics = false;
        }
        this.target = null;
        this.ghost.getNavigation().stop();
    }

    public void tick() {
        boolean blocked;
        double dz;
        double dy;
        if (this.target == null) {
            return;
        }
        Vec3 hover = this.target.getEyePosition().add(0.0, 0.6, 0.0);
        double dx = hover.x - this.ghost.getX();
        double distance = Math.sqrt(dx * dx + (dy = hover.y - this.ghost.getY()) * dy + (dz = hover.z - this.ghost.getZ()) * dz);
        if (distance < 1.0E-6) {
            return;
        }
        this.ghost.lookAt((Entity)this.target, 30.0f, 30.0f);
        Vec3 k = hover.subtract(dx / distance * this.minDistance, dy / distance * this.minDistance, dz / distance * this.minDistance);
        Vec3 veloc = k.subtract(this.ghost.position());
        double len = veloc.length();
        if (len > 1.0E-6) {
            veloc = veloc.scale(1.0 / len).scale(this.maxSpeed * (distance >= this.startDistance ? 1.0 : Mth.clamp((double)((distance - this.minDistance) / Math.max(0.1, this.startDistance - this.minDistance)), (double)0.0, (double)1.0)));
        }
        Vec3 current = this.ghost.getDeltaMovement();
        this.ghost.setDeltaMovement(new Vec3(Mth.lerp((double)this.lerpFactor, (double)current.x, (double)veloc.x), Mth.lerp((double)this.lerpFactor, (double)current.y, (double)veloc.y), Mth.lerp((double)this.lerpFactor, (double)current.z, (double)veloc.z)));
        if (distance <= this.minDistance + 0.25) {
            this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().scale(0.85));
        }
        this.ghost.noPhysics = blocked = this.canGoThrough(this.ghost.level(), this.ghost.getEyePosition(), k);
        this.forcedNoPhysics = blocked;
    }

    private boolean canGoThrough(Level lvl, Vec3 from, Vec3 to) {
        return lvl.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.ghost)).getType() != HitResult.Type.MISS;
    }
}

