/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.MainGhostEntity;
import dev.xylonity.bonsai.ghosts.config.GhostsConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GhostFollowOwnerGoal
extends Goal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = GhostsConfig.GHOSTS_FOLLOW_OWNER_TELEPORT_DISTANCE;
    private final double minDistance;
    private final double startDistance;
    private final double maxSpeedModifier;
    private final float lerpFactor;
    private final MainGhostEntity ghost;
    private final PathNavigation navigation;
    private LivingEntity owner;

    public GhostFollowOwnerGoal(MainGhostEntity ghost, double maxSpeedModifier, double minDistance, double startDistance, float lerpFactor) {
        this.ghost = ghost;
        this.maxSpeedModifier = maxSpeedModifier;
        this.minDistance = minDistance;
        this.startDistance = startDistance;
        this.lerpFactor = lerpFactor;
        this.navigation = this.ghost.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        LivingEntity poss = this.ghost.getOwner();
        if (poss == null || !poss.isAlive()) {
            return false;
        }
        if (this.ghost.distanceToSqr((Entity)poss) < this.startDistance * this.startDistance) {
            return false;
        }
        this.owner = poss;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.owner == null) {
            return false;
        }
        if (!this.owner.isAlive()) {
            return false;
        }
        return this.ghost.distanceToSqr((Entity)this.owner) > this.minDistance * this.minDistance;
    }

    public void tick() {
        if (this.owner == null) {
            return;
        }
        if (this.ghost.distanceToSqr((Entity)this.owner) >= (double)(TELEPORT_WHEN_DISTANCE_IS * TELEPORT_WHEN_DISTANCE_IS)) {
            this.teleportToOwner();
        }
        this.ghost.lookAt((Entity)this.owner, 30.0f, 30.0f);
        double dx = this.owner.getX() - this.ghost.getX();
        double dy = this.owner.getY() + 2.0 - this.ghost.getY();
        double dz = this.owner.getZ() - this.ghost.getZ();
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dist <= this.minDistance) {
            Vec3 slowed = this.ghost.getDeltaMovement().scale(0.9);
            this.ghost.setDeltaMovement(slowed);
            if (slowed.lengthSqr() < 0.01) {
                this.navigation.stop();
                this.ghost.getMoveControl().setWantedPosition(this.ghost.getX(), this.ghost.getY(), this.ghost.getZ(), 0.0);
            }
            this.ghost.noPhysics = false;
            return;
        }
        double theta = dist >= this.startDistance ? 1.0 : Mth.clamp((double)((dist - this.minDistance) / (this.startDistance - this.minDistance)), (double)0.0, (double)1.0);
        Vec3 target = new Vec3(this.owner.getX() - dx / dist * this.minDistance, this.owner.getY() + 2.0 - dy / dist * this.minDistance, this.owner.getZ() - dz / dist * this.minDistance);
        Vec3 vel = target.subtract(this.ghost.position()).normalize().scale(this.maxSpeedModifier * theta);
        Vec3 cVel = this.ghost.getDeltaMovement();
        this.ghost.setDeltaMovement(new Vec3(Mth.lerp((double)this.lerpFactor, (double)cVel.x, (double)vel.x), Mth.lerp((double)this.lerpFactor, (double)cVel.y, (double)vel.y), Mth.lerp((double)this.lerpFactor, (double)cVel.z, (double)vel.z)));
        this.ghost.noPhysics = this.isPathBlocked(this.ghost.level(), this.ghost.getEyePosition(), target);
    }

    private boolean isPathBlocked(Level level, Vec3 from, Vec3 to) {
        return level.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.ghost)).getType() != HitResult.Type.MISS;
    }

    protected void teleportToOwner() {
        BlockPos pos = this.owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(-3, 3);
            int y = this.randomIntInclusive(-1, 1);
            int z = this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(pos.getX() + x, pos.getY() + y, pos.getZ() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.getX()) < 2.0 && Math.abs((double)pZ - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.ghost.moveTo((float)pX + 0.5f, pY, (float)pZ + 0.5f, this.ghost.getYRot(), this.ghost.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        if (FlyNodeEvaluator.getPathTypeStatic((Mob)this.ghost, (BlockPos)pPos.mutable()) != PathType.WALKABLE) {
            return false;
        }
        if (this.ghost.level().getBlockState(pPos.below()).getBlock() instanceof LeavesBlock) {
            return false;
        }
        return this.ghost.level().noCollision((Entity)this.ghost, this.ghost.getBoundingBox().move(pPos.subtract((Vec3i)this.ghost.blockPosition())));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.ghost.getRandom().nextInt(pMax - pMin + 1) + pMin;
    }
}

