/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GhostPlaceGoal
extends Goal {
    private final GhostEntity ghost;
    private final Ingredient placeables;
    private final Predicate<BlockState> preference;
    private final int minLight;
    private final int retryCooldown;
    private final double approachSpeed;
    private static final double DIST_2_PLACE_TORCH = 1.0;
    private static final double STOP_DIST = 49.0;
    private static final double APPROACH_BACKSLASH = 0.5;
    private static final int IGNORE_RECENT_TORCH = 100;
    private int nextTryTickk = 0;
    private BlockPos basePos = null;
    private Vec3 approachPos = null;
    private int stuckTicks = 0;
    private Vec3 lastPos = null;
    private BlockPos recentUp = null;
    private int avoidLatest = 0;

    public GhostPlaceGoal(GhostEntity ghost, Ingredient placeables, Predicate<BlockState> pref, int lightThreshold, int retry, double speed) {
        this.ghost = ghost;
        this.placeables = placeables;
        this.preference = pref;
        this.minLight = lightThreshold;
        this.retryCooldown = Math.max(5, retry);
        this.approachSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.ghost.isInSittingPose() || this.ghost.isPassenger()) {
            return false;
        }
        if (this.ghost.tickCount < this.nextTryTickk) {
            return false;
        }
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.isEmpty() || !this.placeables.test(stack) || !(stack.getItem() instanceof BlockItem)) {
            return false;
        }
        BlockPos base = this.findBlock(this.ghost.level());
        if (base == null) {
            return false;
        }
        BlockPos above = base.above();
        Level level = this.ghost.level();
        if (!this.preference.test(level.getBlockState(base))) {
            return false;
        }
        if (!level.getBlockState(above).canBeReplaced()) {
            return false;
        }
        if (level.getMaxLocalRawBrightness(above) > this.minLight) {
            return false;
        }
        if (!((BlockItem)stack.getItem()).getBlock().defaultBlockState().canSurvive((LevelReader)level, above)) {
            return false;
        }
        this.basePos = base;
        this.approachPos = new Vec3((double)this.basePos.getX() + 0.5, (double)this.basePos.getY() + 1.2, (double)this.basePos.getZ() + 0.5);
        this.stuckTicks = 0;
        this.lastPos = this.ghost.position();
        return true;
    }

    private boolean isRecentlyPlacedInA(BlockPos up) {
        if (this.recentUp == null) {
            return false;
        }
        if (this.ghost.tickCount > this.avoidLatest) {
            return false;
        }
        int dx = Math.abs(up.getX() - this.recentUp.getX());
        int dy = Math.abs(up.getY() - this.recentUp.getY());
        int dz = Math.abs(up.getZ() - this.recentUp.getZ());
        return dx <= 1 && dy <= 1 && dz <= 1;
    }

    public boolean canContinueToUse() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.basePos == null || this.approachPos == null) {
            return false;
        }
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.isEmpty() || !this.placeables.test(stack) || !(stack.getItem() instanceof BlockItem)) {
            return false;
        }
        if (!this.ghost.level().getBlockState(this.basePos.above()).canBeReplaced()) {
            return false;
        }
        if (this.ghost.level().getMaxLocalRawBrightness(this.basePos.above()) > this.minLight) {
            return false;
        }
        return this.ghost.getOwner() == null || !(this.ghost.distanceToSqr((Entity)this.ghost.getOwner()) > 49.0);
    }

    public void start() {
        Vec3 to = this.goBackAfterPlacing(this.approachPos);
        this.ghost.getNavigation().moveTo(to.x, to.y, to.z, this.approachSpeed);
        this.ghost.getMoveControl().setWantedPosition(to.x, to.y, to.z, this.approachSpeed);
    }

    public void stop() {
        this.basePos = null;
        this.approachPos = null;
        this.lastPos = null;
        this.stuckTicks = 0;
        this.ghost.getNavigation().stop();
        this.nextTryTickk = this.ghost.tickCount + this.retryCooldown;
    }

    public void tick() {
        if (this.basePos == null) {
            return;
        }
        BlockPos up = this.basePos.above();
        Vec3 u = new Vec3((double)up.getX() + 0.5, (double)up.getY() + 0.5, (double)up.getZ() + 0.5);
        this.ghost.getLookControl().setLookAt(u.x, u.y, u.z);
        if (this.lastPos != null) {
            this.stuckTicks = this.lastPos.distanceTo(this.ghost.position()) < 0.02 ? ++this.stuckTicks : 0;
        }
        this.lastPos = this.ghost.position();
        Vec3 wanted = this.goBackAfterPlacing(this.approachPos);
        if (this.stuckTicks > 8) {
            this.ghost.getNavigation().moveTo(wanted.x, wanted.y, wanted.z, this.approachSpeed);
            this.ghost.getMoveControl().setWantedPosition(wanted.x, wanted.y, wanted.z, this.approachSpeed);
            this.stuckTicks = 0;
        }
        if (this.ghost.position().distanceTo(u) <= 1.0 && this.canSeePos(up)) {
            this.place(up);
            return;
        }
        if (this.ghost.position().distanceTo(wanted) > 0.25) {
            this.ghost.getNavigation().moveTo(wanted.x, wanted.y, wanted.z, this.approachSpeed);
            this.ghost.getMoveControl().setWantedPosition(wanted.x, wanted.y, wanted.z, this.approachSpeed);
        }
    }

    private void place(BlockPos up) {
        Item item;
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem)) {
            this.stop();
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!this.ghost.level().getBlockState(up).canBeReplaced() || !blockItem.getBlock().defaultBlockState().canSurvive((LevelReader)this.ghost.level(), up)) {
            this.stop();
            return;
        }
        this.ghost.triggerAnim("torch_place_controller", "torch_place");
        this.ghost.level().setBlock(up, blockItem.getBlock().defaultBlockState(), 3);
        stack.shrink(1);
        if (stack.isEmpty()) {
            this.ghost.setHoldItem(ItemStack.EMPTY);
        }
        this.recentUp = up.immutable();
        this.avoidLatest = this.ghost.tickCount + 100;
        this.stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private Vec3 goBackAfterPlacing(Vec3 target) {
        double d = target.subtract(this.ghost.position()).length();
        if (d < 0.001) {
            return target;
        }
        return this.ghost.position().add(target.subtract(this.ghost.position()).scale(Math.max(0.0, d - 0.5) / d));
    }

    private boolean canSeePos(BlockPos up) {
        Vec3 target = new Vec3((double)up.getX() + 0.5, (double)up.getY() + 0.5, (double)up.getZ() + 0.5);
        BlockHitResult hit = this.ghost.level().clip(new ClipContext(this.ghost.getEyePosition(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.ghost));
        if (hit.getType() == HitResult.Type.MISS) {
            return true;
        }
        if (hit instanceof BlockHitResult) {
            BlockHitResult bhr = hit;
            return bhr.getBlockPos().equals((Object)up);
        }
        return false;
    }

    private BlockPos findBlock(Level level) {
        for (int dy = 0; dy <= 4; ++dy) {
            BlockPos[] possiblePositions;
            BlockPos pos = new BlockPos(Mth.floor((double)this.ghost.getX()), Mth.floor((double)this.ghost.getY()) - 1 - dy, Mth.floor((double)this.ghost.getZ()));
            if (level.getBlockState(pos).isAir()) continue;
            for (BlockPos b : possiblePositions = new BlockPos[]{pos, pos.east(), pos.west(), pos.north(), pos.south()}) {
                BlockPos up = b.above();
                if (this.isRecentlyPlacedInA(up) || !this.preference.test(level.getBlockState(b)) || !level.getBlockState(up).canBeReplaced() || level.getMaxLocalRawBrightness(up) > this.minLight) continue;
                return b;
            }
        }
        return null;
    }
}

