/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ghost;

import dev.xylonity.bonsai.ghosts.common.entity.MainGhostEntity;
import dev.xylonity.bonsai.ghosts.common.entity.ai.control.GhostMoveControl;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostApproachHeldGlowBerriesGoal;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostFollowOwnerGoal;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostPlaceGoal;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostWanderGoal;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.StayWhenOrderedToGoal;
import dev.xylonity.bonsai.ghosts.registry.GhostsSounds;
import dev.xylonity.bonsai.ghosts.tag.GhostsTags;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class GhostEntity
extends MainGhostEntity {
    private static final EntityDataAccessor<Boolean> SHOULD_RESET_CD = SynchedEntityData.defineId(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> BLINK_CD = SynchedEntityData.defineId(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BLINK_ANIM_CD = SynchedEntityData.defineId(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SHOULD_UNENCHANT = SynchedEntityData.defineId(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int cdUnenchant = 0;

    public GhostEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.BLOCKED, -1.0f);
        this.setPathfindingMalus(PathType.LEAVES, -1.0f);
        this.moveControl = new GhostMoveControl(this);
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, level);
        navigator.setCanOpenDoors(false);
        navigator.setCanFloat(true);
        navigator.setCanPassDoors(true);
        return navigator;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return AbstractGolem.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FLYING_SPEED, (double)0.3f).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new StayWhenOrderedToGoal(this));
        this.goalSelector.addGoal(3, (Goal)new GhostApproachHeldGlowBerriesGoal(this, 0.6, 1.6, 6.0, 0.1f, 12));
        this.goalSelector.addGoal(7, (Goal)new GhostFollowOwnerGoal(this, 0.6, 3.0, 7.0, 0.2f));
        this.goalSelector.addGoal(6, (Goal)new GhostPlaceGoal(this, Ingredient.of(GhostsTags.GHOST_PLACEABLE), state -> true, 6, 10, 0.75));
        this.goalSelector.addGoal(9, (Goal)new GhostWanderGoal(this, 0.43f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOULD_RESET_CD, (Object)false);
        builder.define(BLINK_CD, (Object)0);
        builder.define(BLINK_ANIM_CD, (Object)0);
        builder.define(SHOULD_UNENCHANT, (Object)false);
    }

    public void setHoldItem(ItemStack holdItem) {
        if (this.shouldUnechant()) {
            this.setShouldUnenchant(false);
            this.setCdUnenchant(0);
        }
        if (holdItem.isEnchanted()) {
            this.setShouldUnenchant(true);
            this.setCdUnenchant(82);
        }
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.MAINHAND, holdItem);
    }

    public int getCdUnenchant() {
        return this.cdUnenchant;
    }

    public void setCdUnenchant(int cd) {
        this.cdUnenchant = cd;
    }

    public int getBlinkCd() {
        return (Integer)this.entityData.get(BLINK_CD);
    }

    public void setBlinkCd(int cd) {
        this.entityData.set(BLINK_CD, (Object)cd);
    }

    public int getBlinkAnimCd() {
        return (Integer)this.entityData.get(BLINK_ANIM_CD);
    }

    public void setBlinkAnimCd(int cd) {
        this.entityData.set(BLINK_ANIM_CD, (Object)cd);
    }

    public void setShouldResetCd(boolean shouldResetCd) {
        this.entityData.set(SHOULD_RESET_CD, (Object)shouldResetCd);
    }

    public boolean getShouldResetCd() {
        return (Boolean)this.entityData.get(SHOULD_RESET_CD);
    }

    private void setShouldUnenchant(boolean shouldUnenchant) {
        this.entityData.set(SHOULD_UNENCHANT, (Object)shouldUnenchant);
    }

    private boolean shouldUnechant() {
        return (Boolean)this.entityData.get(SHOULD_UNENCHANT);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CdUnenchant", this.getCdUnenchant());
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isTame() && stack.getItem() == Items.GLOW_BERRIES) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (this.random.nextInt(3) == 0) {
                this.tame(player);
                this.setPersistenceRequired();
                this.navigation.stop();
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                return InteractionResult.SUCCESS;
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
            return InteractionResult.FAIL;
        }
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && player == this.getOwner()) {
            if (player.isShiftKeyDown()) {
                if (stack.getItem() == Items.GLOW_BERRIES && this.getHealth() < this.getMaxHealth()) {
                    this.heal(4.0f);
                } else {
                    if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty() && (this.getEquipmentSlotForItem(stack) == EquipmentSlot.HEAD || stack.is(Items.BROWN_MUSHROOM) || stack.is(Items.RED_MUSHROOM))) {
                        ItemStack copy = stack.copy();
                        copy.setCount(1);
                        this.setItemSlotAndDropWhenKilled(EquipmentSlot.HEAD, copy);
                        if (!player.getAbilities().instabuild) {
                            stack.shrink(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (!stack.isEmpty() && this.getHoldItem().isEmpty()) {
                        this.setHoldItem(stack.copy());
                        stack.setCount(0);
                    } else if (!this.getHoldItem().isEmpty()) {
                        this.spawnAtLocation(this.getHoldItem(), 0.5f);
                        this.setHoldItem(ItemStack.EMPTY);
                    } else if (!this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                        this.spawnAtLocation(this.getItemBySlot(EquipmentSlot.HEAD), 0.5f);
                        this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                }
            } else {
                this.cycleMainInteraction(player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected int getBaseExperienceReward() {
        return 1 + this.level().random.nextInt(2, 4);
    }

    public void tick() {
        ItemStack heldItemStack;
        super.tick();
        this.setNoGravity(true);
        if (this.level().isClientSide) {
            return;
        }
        this.rotateBody();
        if (this.getBlinkCd() > 0) {
            this.setBlinkCd(this.getBlinkCd() - 1);
        } else if (this.getBlinkAnimCd() > 0) {
            this.setBlinkAnimCd(this.getBlinkAnimCd() - 1);
        } else if (this.getShouldResetCd()) {
            this.setShouldResetCd(false);
            this.setBlinkCd(this.random.nextInt(80, 120));
        } else {
            this.setShouldResetCd(true);
            this.setBlinkAnimCd(6);
        }
        if (this.getCdUnenchant() > 0) {
            this.setCdUnenchant(this.getCdUnenchant() - 1);
        }
        if ((heldItemStack = this.getHoldItem()).isEnchanted()) {
            if (this.getCdUnenchant() == 10 && this.shouldUnechant()) {
                this.spawnAtLocation(this.removeEnchants(heldItemStack), 0.5f);
                this.setHoldItem(ItemStack.EMPTY);
                this.setShouldUnenchant(false);
            } else if (this.getCdUnenchant() == 0) {
                if (!this.shouldUnechant()) {
                    this.startUnenchantAnim();
                } else {
                    this.spawnAtLocation(this.removeEnchants(heldItemStack), 0.5f);
                    this.setHoldItem(ItemStack.EMPTY);
                    this.setShouldUnenchant(false);
                }
            }
        }
    }

    private void startUnenchantAnim() {
        this.setCdUnenchant(82);
        this.setShouldUnenchant(true);
    }

    private ItemStack removeEnchants(ItemStack item) {
        ItemEnchantments target;
        ItemStack stack = item.copy();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel srv = (ServerLevel)level;
            ExperienceOrb.award((ServerLevel)srv, (Vec3)this.getPosition(0.0f), (int)this.getExperienceFromItem(stack));
        }
        ItemEnchantments normal = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments stored = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        boolean storedComp = !stored.isEmpty();
        ItemEnchantments itemEnchantments = target = storedComp ? stored : normal;
        if (!target.isEmpty()) {
            ArrayList keys = new ArrayList(target.keySet());
            Holder rem = (Holder)keys.get(this.random.nextInt(keys.size()));
            ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(target);
            mut.set(rem, 0);
            ItemEnchantments imm = mut.toImmutable();
            if (storedComp) {
                if (imm.isEmpty()) {
                    stack.remove(DataComponents.STORED_ENCHANTMENTS);
                } else {
                    stack.set(DataComponents.STORED_ENCHANTMENTS, (Object)imm);
                }
            } else if (imm.isEmpty()) {
                stack.remove(DataComponents.ENCHANTMENTS);
            } else {
                stack.set(DataComponents.ENCHANTMENTS, (Object)imm);
            }
        }
        stack.remove(DataComponents.STORED_ENCHANTMENTS);
        stack.set(DataComponents.REPAIR_COST, (Object)AnvilMenu.calculateIncreasedRepairCost((int)((Integer)stack.getOrDefault(DataComponents.REPAIR_COST, (Object)0))));
        return stack.copy();
    }

    private int getExperienceFromItem(ItemStack stack) {
        return this.xpFrom((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)) + this.xpFrom((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
    }

    private int xpFrom(ItemEnchantments ench) {
        int xp = 0;
        for (Holder holder : ench.keySet()) {
            int lvl;
            if (holder.is(EnchantmentTags.CURSE) || (lvl = ench.getLevel(holder)) <= 0) continue;
            xp += ((Enchantment)holder.value()).getMinCost(lvl);
        }
        return xp;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("CdUnenchant")) {
            this.setCdUnenchant(compound.getInt("CdUnenchant"));
        }
    }

    protected SoundEvent getAmbientSound() {
        return GhostsSounds.GHOST_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return GhostsSounds.GHOST_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return GhostsSounds.GHOST_HURT.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController((GeoAnimatable)this, "bodyController", 4, this::bodyAC));
        registrar.add(new AnimationController((GeoAnimatable)this, "armsController", 4, this::armsAC));
        registrar.add(new AnimationController((GeoAnimatable)this, "blinkController", 2, this::blinkAC));
        registrar.add(new AnimationController((GeoAnimatable)this, "torch_place_controller", 2, state -> PlayState.STOP).triggerableAnim("torch_place", RawAnimation.begin().thenPlay("torch_place")));
    }

    private <E extends GeoAnimatable> PlayState bodyAC(AnimationState<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_move"));
        } else if (this.isInSittingPose()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_sitting"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState blinkAC(AnimationState<E> event) {
        if (this.getBlinkCd() == 0) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_blink"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState armsAC(AnimationState<E> event) {
        boolean hasItem;
        boolean bl = hasItem = !this.getHoldItem().isEmpty();
        if (hasItem) {
            if (this.shouldUnechant()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_unenchant"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_arms_hold"));
            }
        } else if (this.isInSittingPose()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_idle_arms"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop(event.isMoving() ? "ghost_move_arms" : "ghost_idle_arms"));
        }
        return PlayState.CONTINUE;
    }
}

