/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ghost;

import dev.xylonity.bonsai.ghosts.common.entity.MainGhostEntity;
import dev.xylonity.bonsai.ghosts.common.entity.ai.control.GhostMoveControl;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostWanderGoal;
import dev.xylonity.bonsai.ghosts.common.entity.variant.SmallGhostVariant;
import dev.xylonity.bonsai.ghosts.registry.GhostsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class SmallGhostEntity
extends MainGhostEntity {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(SmallGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CD_FULL_HIDE = SynchedEntityData.defineId(SmallGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_STAYING = SynchedEntityData.defineId(SmallGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SLEEPING = SynchedEntityData.defineId(SmallGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public SmallGhostEntity(EntityType<? extends TamableAnimal> entity, Level world) {
        super(entity, world);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.BLOCKED, -1.0f);
        this.setPathfindingMalus(PathType.LEAVES, -1.0f);
        this.moveControl = new GhostMoveControl(this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new GhostWanderGoal(this, 0.43f){

            @Override
            public boolean canUse() {
                return super.canUse() && !SmallGhostEntity.this.getIsSleeping();
            }
        });
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, level);
        navigator.setCanOpenDoors(false);
        navigator.setCanFloat(true);
        navigator.setCanPassDoors(true);
        return navigator;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return AbstractGolem.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)0.3f).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_STAYING, (Object)false);
        builder.define(IS_SLEEPING, (Object)false);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.define(CD_FULL_HIDE, (Object)0);
    }

    public void setIsStaying(boolean isStaying) {
        this.entityData.set(IS_STAYING, (Object)isStaying);
    }

    public boolean getIsStaying() {
        return (Boolean)this.entityData.get(IS_STAYING);
    }

    public void setHoldItem(ItemStack holdItem) {
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.MAINHAND, holdItem);
    }

    @Override
    public ItemStack getHoldItem() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND);
    }

    public void setIsSleeping(boolean isSleeping) {
        this.entityData.set(IS_SLEEPING, (Object)isSleeping);
    }

    public boolean getIsSleeping() {
        return (Boolean)this.entityData.get(IS_SLEEPING);
    }

    public int getCdFullHide() {
        return (Integer)this.entityData.get(CD_FULL_HIDE);
    }

    public void setCdFullHide(int cd) {
        this.entityData.set(CD_FULL_HIDE, (Object)cd);
    }

    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public SmallGhostVariant getVariant() {
        return SmallGhostVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(SmallGhostVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void setVariant(int variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant & 0xFF));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt("Variant", this.getVariant().getId());
        compoundTag.putInt("CdFullHide", this.getCdFullHide());
        compoundTag.putBoolean("IsStaying", this.getIsStaying());
        compoundTag.putBoolean("IsSleeping", this.getIsSleeping());
    }

    protected int getBaseExperienceReward() {
        return 1 + this.level().random.nextInt(2, 4);
    }

    public boolean isPushable() {
        return false;
    }

    public void push(Entity entity) {
        if (!this.getIsSleeping()) {
            super.push(entity);
        }
    }

    protected void doPush(Entity entity) {
        if (!this.getIsSleeping()) {
            super.doPush(entity);
        }
    }

    public boolean fireImmune() {
        return true;
    }

    public void tick() {
        SmallGhostVariant variant;
        super.tick();
        this.setNoGravity(true);
        if (this.level().isClientSide) {
            return;
        }
        if (this.getIsSleeping() && this.getCdFullHide() == 36) {
            BlockPos targetBlock = this.blockPosition().below();
            BlockState belowState = this.level().getBlockState(targetBlock);
            if (!belowState.isAir() && this.level() instanceof ServerLevel) {
                this.noPhysics = true;
                this.setDeltaMovement(Vec3.ZERO);
                this.setPos(this.getX(), (double)targetBlock.getY() + 1.0 + 0.15 - (double)this.getBbHeight() / 2.0, this.getZ());
            }
        }
        this.rotateBody();
        if (this.getCdFullHide() > 0) {
            this.setCdFullHide(this.getCdFullHide() - 1);
        }
        if ((variant = this.getVariant()) == SmallGhostVariant.PLANT) {
            BlockState belowBlockState = this.level().getBlockState(this.blockPosition().below());
            if (!this.level().isDay() && (belowBlockState.is(Blocks.GRASS_BLOCK) || belowBlockState.is(Blocks.DIRT))) {
                if (!this.getIsSleeping()) {
                    this.setCdFullHide(36);
                }
                this.setIsSleeping(true);
            } else {
                this.setIsSleeping(false);
            }
        }
        if (this.noPhysics && this.getDeltaMovement().lengthSqr() < 1.0E-4) {
            this.noPhysics = false;
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (this.getIsSleeping() && this.getCdFullHide() == 26) {
            Level level;
            BlockPos belowPos = this.blockPosition().below();
            BlockState belowState = this.level().getBlockState(belowPos);
            if (!belowState.isAir() && (level = this.level()) instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                for (int i = 0; i < 10; ++i) {
                    double ox = (this.random.nextDouble() - 0.5) * 0.6;
                    double oz = (this.random.nextDouble() - 0.5) * 0.6;
                    double oy = this.random.nextDouble() * 0.15;
                    sl.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, belowState), this.getX() + ox, this.getY() + 0.05 + oy, this.getZ() + oz, 1, 0.0, 0.02, 0.0, 0.0);
                }
                sl.playSound(null, this.getX(), this.getY(), this.getZ(), belowState.getSoundType().getBreakSound(), this.getSoundSource(), 0.8f, 0.9f + this.random.nextFloat() * 0.2f);
            }
        }
    }

    private void moveToPos(Vec3 target, double speed, float lerp) {
        Vec3 tetha = target.subtract(this.position());
        if (tetha.length() < 0.001) {
            return;
        }
        this.noPhysics = true;
        Vec3 vel = tetha.scale(1.0 / tetha.length()).scale(speed);
        Vec3 v = this.getDeltaMovement();
        this.setDeltaMovement(Mth.lerp((double)lerp, (double)v.x, (double)vel.x), Mth.lerp((double)lerp, (double)v.y, (double)vel.y), Mth.lerp((double)lerp, (double)v.z, (double)vel.z));
        this.getLookControl().setLookAt(target.x, target.y, target.z);
    }

    @Override
    public boolean hurt(DamageSource source, float p) {
        Vec3 vec;
        if (source.getEntity() != null && (vec = AirRandomPos.getPosTowards((PathfinderMob)this, (int)32, (int)32, (int)32, (Vec3)new Vec3(32.0, 32.0, 32.0), (double)32.0)) != null) {
            this.moveToPos(vec, 0.55, 0.6f);
        }
        return super.hurt(source, p);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains("Variant")) {
            this.setVariant(compoundTag.getInt("Variant"));
        }
        if (compoundTag.contains("CdFullHide")) {
            this.setCdFullHide(compoundTag.getInt("CdFullHide"));
        }
        if (compoundTag.contains("IsStaying")) {
            this.setIsStaying(compoundTag.getBoolean("IsStaying"));
        }
        if (compoundTag.contains("IsSleeping")) {
            this.setIsSleeping(compoundTag.getBoolean("IsSleeping"));
        } else if (compoundTag.contains("IsHiding")) {
            this.setIsSleeping(compoundTag.getBoolean("IsHiding"));
        }
    }

    protected SoundEvent getAmbientSound() {
        return GhostsSounds.SMALL_GHOST_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return GhostsSounds.SMALL_GHOST_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return GhostsSounds.SMALL_GHOST_HURT.get();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant(level.getRandom().nextBoolean() ? SmallGhostVariant.PLANT : SmallGhostVariant.NORMAL);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    private <E extends GeoAnimatable> PlayState bodyAC(AnimationState<E> event) {
        if (event.isMoving() && !this.getIsSleeping()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_move"));
            return PlayState.CONTINUE;
        }
        if (this.getIsSleeping()) {
            if (this.getCdFullHide() > 0) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_bury"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("mini_ghost_buried"));
            }
            return PlayState.CONTINUE;
        }
        if (!this.getIsSleeping() && !event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState armsAC(AnimationState<E> event) {
        if (!this.getHoldItem().isEmpty()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("mini_ghost_arms_hold"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop(event.isMoving() ? "ghost_move_arms" : "ghost_idle_arms"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController((GeoAnimatable)this, "small_ghost_animation_controller_body", 1, this::bodyAC));
        registrar.add(new AnimationController((GeoAnimatable)this, "small_ghost_animation_controller_arms", 1, this::armsAC));
    }
}

