/*
 * Decompiled with CFR 0.152.
 */
package net.yonchi.refm.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.yonchi.refm.gameasset.RapierAnimations;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class DeadlyBackflipSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("1f6aea85-2194-4761-af8e-1a5c99c4f414");
    private final AnimationProvider<AttackAnimation> first = () -> (AttackAnimation)RapierAnimations.DEADLYBACKFLIP_FIRST;
    private final AnimationProvider<AttackAnimation> second = () -> (AttackAnimation)RapierAnimations.DEADLYBACKFLIP_SECOND;

    public DeadlyBackflipSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            List hurtEntities;
            if (RapierAnimations.DEADLYBACKFLIP_FIRST.equals((Object)event.getAnimation()) && !(hurtEntities = ((ServerPlayerPatch)event.getPlayerPatch()).getCurrenltyHurtEntities()).isEmpty() && ((LivingEntity)hurtEntities.get(0)).m_6084_()) {
                ((ServerPlayerPatch)event.getPlayerPatch()).getServerAnimator().getPlayerFor(null).reset();
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(this.second.get(), 0.0f);
                ((ServerPlayerPatch)event.getPlayerPatch()).getCurrenltyHurtEntities().clear();
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    public boolean checkExecuteCondition(PlayerPatch<?> executer) {
        LivingEntity target = executer.getTarget();
        if (target != null && target.m_6084_()) {
            double distance = ((Player)executer.getOriginal()).m_20270_((Entity)target);
            double minDistance = 1.2;
            double maxDistance = 8.0;
            Vec3 playerPos = ((Player)executer.getOriginal()).m_20182_();
            Vec3 targetPos = target.m_20182_();
            Vec3 directionToTarget = targetPos.m_82546_(playerPos).m_82541_();
            Vec3 playerLook = ((Player)executer.getOriginal()).m_20154_().m_82541_();
            double angle = Math.acos(playerLook.m_82526_(directionToTarget));
            double angleInDegrees = Math.toDegrees(angle);
            double angleThreshold = 92.0;
            if (distance >= minDistance && distance <= maxDistance && angleInDegrees <= angleThreshold) {
                return true;
            }
        }
        return false;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        executer.playAnimationSynchronized(this.first.get(), 0.0f);
        LivingEntity target = executer.getTarget();
        if (target != null && target.m_6084_()) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 36, 50));
        }
        super.executeOnServer(executer, args);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Kick:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Stab:");
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        ((AttackAnimation)this.first.get()).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)this.second.get()).phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        return this;
    }
}

