/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.french;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class LimestoneGargoyleBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    private static final IntegerProperty HUMIDITY = BlockStatePropertiesAA.HUMIDITY_0_8;

    public LimestoneGargoyleBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.LIMESTONE_GARGOYLE_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HUMIDITY, (Comparable)Integer.valueOf(0))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    private int getMaxHumidity() {
        return 8;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HUMIDITY, PERSISTENT});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122416_();
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
            if (player.m_7500_()) {
                int humidity = (Integer)state.m_61143_((Property)HUMIDITY);
                if (player.m_6047_()) {
                    if (humidity > 0) {
                        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HUMIDITY, (Comparable)Integer.valueOf(humidity - 1)), 10);
                        return InteractionResult.SUCCESS;
                    }
                } else if (humidity < this.getMaxHumidity()) {
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HUMIDITY, (Comparable)Integer.valueOf(humidity + 1)), 10);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (Utils.useLighter(worldIn, pos, player, handIn)) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                worldIn.m_7107_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_() + 0.5 + rand.nextDouble() / 2.0, (double)pos.m_123343_() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    @NotNull
    public BlockState m_6943_(BlockState state, @NotNull Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int humidity = (Integer)state.m_61143_((Property)HUMIDITY);
        if (humidity > 0) {
            if (humidity == this.getMaxHumidity()) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                double x = (double)pos.m_123341_() + (8.0 + (double)facing.m_122429_() * 6.0) / 16.0;
                double y = (double)pos.m_123342_() + 0.59375;
                double z = (double)pos.m_123343_() + (8.0 + (double)facing.m_122431_() * 6.0) / 16.0;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123803_, x, y - 0.0625, z, 0.0, 0.0, 0.0);
            } else if (rand.m_188503_(this.getMaxHumidity() - humidity + 1) == 0) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                double x = (double)pos.m_123341_() + (8.0 + (double)facing.m_122429_() * 6.0) / 16.0;
                double y = (double)pos.m_123342_() + 0.59375;
                double z = (double)pos.m_123343_() + (8.0 + (double)facing.m_122431_() * 6.0) / 16.0;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        int humidity = (Integer)state.m_61143_((Property)HUMIDITY);
        if (((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
            super.m_213898_(state, world, pos, rand);
            return;
        }
        if (world.m_46471_() && world.m_45527_(pos)) {
            if ((Integer)state.m_61143_((Property)HUMIDITY) < this.getMaxHumidity()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)HUMIDITY, (Comparable)Integer.valueOf(this.getMaxHumidity())), 2);
            }
        } else if (rand.m_188503_(5) == 0 && humidity > 0) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)HUMIDITY, (Comparable)Integer.valueOf(humidity - 1)), 2);
        }
        super.m_213898_(state, world, pos, rand);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluid.m_76152_() == Fluids.f_76193_) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HUMIDITY, (Comparable)Integer.valueOf(0)), 2);
            world.m_186469_(pos, fluid.m_76152_(), fluid.m_76152_().m_6718_((LevelReader)world));
            return true;
        }
        return false;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, this, new String[0]);
    }
}

