/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.general.FireplaceBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalSidedBlock;
import org.dawnoftime.dawnoftime.block.templates.ConnectedVerticalSidedPlanFireplaceBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.jetbrains.annotations.NotNull;

public class ChimneyBlockDoT
extends ConnectedVerticalBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public ChimneyBlockDoT(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61443_});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos belowBlockPos;
        BlockState state = super.m_5573_(context);
        Level world = context.m_43725_();
        BlockState blockState = world.m_8055_(belowBlockPos = context.m_8083_().m_7495_());
        if (blockState.m_60734_() instanceof ChimneyBlockDoT) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)));
        }
        if (blockState.m_60734_() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            BlockState foundBlockState;
            belowBlockPos = belowBlockPos.m_7495_();
            while ((foundBlockState = world.m_8055_(belowBlockPos)).m_60734_() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
                blockState = foundBlockState;
                belowBlockPos = belowBlockPos.m_7495_();
            }
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)));
        }
        return state;
    }

    @Override
    public InteractionResult m_6227_(BlockState blockStateIn, Level worldIn, BlockPos blockPosIn, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (super.m_6227_(blockStateIn, worldIn, blockPosIn, player, handIn, hit).equals((Object)InteractionResult.SUCCESS)) {
            return InteractionResult.SUCCESS;
        }
        int activation = Utils.changeBlockLitStateWithItemOrCreativePlayer(blockStateIn, worldIn, blockPosIn, player, handIn);
        if (activation >= 0) {
            boolean isActivated = activation == 1;
            ChimneyBlockDoT.updateAllChimneyConductParts(isActivated, blockStateIn, blockPosIn, worldIn);
            ChimneyBlockDoT.updateFireplace(isActivated, blockPosIn, worldIn);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        int activation = -1;
        if (!((Boolean)state.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() && !((Boolean)state.m_61143_((Property)FireplaceBlock.LIT)).booleanValue() && (projectile instanceof Arrow && ((Arrow)projectile).m_6060_() || projectile instanceof Fireball)) {
            activation = 1;
        } else if (((Boolean)state.m_61143_((Property)FireplaceBlock.LIT)).booleanValue() && (projectile instanceof Snowball || projectile instanceof ThrowableProjectile && PotionUtils.m_43579_((ItemStack)((ThrowableItemProjectile)projectile).m_7846_()).m_43488_().size() <= 0)) {
            activation = 0;
        }
        if (activation >= 0) {
            boolean isActivated;
            BlockPos pos = hit.m_82425_();
            boolean bl = isActivated = activation == 1;
            if (!worldIn.m_5776_()) {
                ChimneyBlockDoT.updateAllChimneyConductParts(isActivated, state, pos, worldIn);
                worldIn.m_5594_(null, pos, isActivated ? SoundEvents.f_11936_ : SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (!isActivated && worldIn.m_5776_()) {
                for (int i = 0; i < worldIn.f_46441_.m_188503_(1) + 1; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (double)(worldIn.f_46441_.m_188501_() / 4.0f), 2.5E-5, (double)(worldIn.f_46441_.m_188501_() / 4.0f));
                }
            }
        }
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return;
        }
        if (stateIn.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.UNDER || stateIn.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE) {
            worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123778_, true, (double)pos.m_123341_() + rand.m_188500_() * 0.5 + 0.25, (double)pos.m_123342_() + rand.m_188500_() * 0.5 + 0.3, (double)pos.m_123343_() + rand.m_188500_() * 0.5 + 0.25, 0.0, 0.07, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)pos.m_123341_() + rand.m_188500_() * 0.5 + 0.25, (double)pos.m_123342_() + rand.m_188500_() * 0.5 + 0.3, (double)pos.m_123343_() + rand.m_188500_() * 0.5 + 0.25, 0.0, 0.04, 0.0);
        }
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facingState.m_60734_() instanceof ChimneyBlockDoT || facingState.m_60734_() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            stateIn.m_61124_((Property)LIT, (Comparable)((Boolean)facingState.m_61143_((Property)LIT)));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "fireplace");
    }

    public static void updateAllChimneyConductParts(boolean isActivatedIn, BlockState stateIn, BlockPos blockPosIn, Level worldIn) {
        stateIn = (BlockState)stateIn.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(isActivatedIn));
        worldIn.m_7731_(blockPosIn, stateIn, 10);
        ChimneyBlockDoT.updateIsActivatedInAllPartsOfBottom(isActivatedIn, stateIn, blockPosIn, worldIn);
        ChimneyBlockDoT.updateIsActivatedInAllPartsOfTop(isActivatedIn, stateIn, blockPosIn, worldIn);
    }

    public static void updateIsActivatedInAllPartsOfBottom(boolean isActivatedIn, BlockState stateIn, BlockPos blockPosIn, Level worldIn) {
        BlockState blockState = null;
        BlockPos blockPos = blockPosIn;
        while ((blockState = worldIn.m_8055_(blockPos = blockPos.m_7495_())) != null && blockState.m_60734_() instanceof ChimneyBlockDoT) {
            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(isActivatedIn));
            worldIn.m_7731_(blockPos, blockState, 10);
        }
    }

    public static void updateIsActivatedInAllPartsOfTop(boolean isActivatedIn, BlockState stateIn, BlockPos blockPosIn, Level worldIn) {
        BlockState blockState = null;
        BlockPos blockPos = blockPosIn;
        while ((blockState = worldIn.m_8055_(blockPos = blockPos.m_7494_())) != null && blockState.m_60734_() instanceof ChimneyBlockDoT) {
            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(isActivatedIn));
            worldIn.m_7731_(blockPos, blockState, 10);
        }
    }

    public static void updateFireplace(boolean isActivatedIn, BlockPos blockPosIn, Level worldIn) {
        BlockState blockState = null;
        BlockPos blockPos = blockPosIn;
        while ((blockState = worldIn.m_8055_(blockPos = blockPos.m_7495_())) != null && blockState.m_60734_() instanceof ChimneyBlockDoT) {
        }
        while ((blockState = worldIn.m_8055_(blockPos = blockPos.m_7495_())) != null && blockState.m_60734_() instanceof ConnectedVerticalSidedPlanFireplaceBlock) {
            BlockStatePropertiesAA.VerticalConnection verticalConnection = (BlockStatePropertiesAA.VerticalConnection)((Object)blockState.m_61143_(ConnectedVerticalBlock.VERTICAL_CONNECTION));
            if (verticalConnection == null || !BlockStatePropertiesAA.VerticalConnection.ABOVE.equals((Object)verticalConnection)) continue;
            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(isActivatedIn));
            worldIn.m_7731_(blockPos, blockState, 10);
            Direction direction = (Direction)blockState.m_61143_((Property)ConnectedVerticalSidedBlock.FACING);
            worldIn.m_8055_(blockPos.m_121945_(direction.m_122428_())).m_60690_(worldIn, blockPos.m_121945_(direction.m_122428_()), blockState.m_60734_(), blockPos, false);
            worldIn.m_8055_(blockPos.m_121945_(direction.m_122427_())).m_60690_(worldIn, blockPos.m_121945_(direction.m_122427_()), blockState.m_60734_(), blockPos, false);
        }
    }
}

