/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SmallShutterBlock
extends WaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<BlockStatePropertiesAA.OpenPosition> OPEN_POSITION = BlockStatePropertiesAA.OPEN_POSITION;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;

    public SmallShutterBlock(BlockBehaviour.Properties properties) {
        super(properties.m_278166_(PushReaction.DESTROY).m_60953_(state -> 1), VoxelShapes.SMALL_SHUTTER_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(OPEN_POSITION, (Comparable)((Object)BlockStatePropertiesAA.OpenPosition.CLOSED))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HINGE, OPEN_POSITION, POWERED});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        boolean hinge = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        return switch ((BlockStatePropertiesAA.OpenPosition)((Object)state.m_61143_(OPEN_POSITION))) {
            default -> throw new IncompatibleClassChangeError();
            case BlockStatePropertiesAA.OpenPosition.FULL -> (hinge ? 1 : 2) + 3 * dir.m_122416_();
            case BlockStatePropertiesAA.OpenPosition.CLOSED -> 3 * dir.m_122416_();
            case BlockStatePropertiesAA.OpenPosition.HALF -> 3 * (hinge ? dir.m_122427_().m_122416_() : dir.m_122428_().m_122416_());
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        Direction direction = context.m_8125_();
        BlockPos pos = context.m_8083_();
        int x = direction.m_122429_();
        int z = direction.m_122431_();
        double onX = context.m_43720_().f_82479_ - (double)pos.m_123341_();
        double onZ = context.m_43720_().f_82481_ - (double)pos.m_123343_();
        boolean hingeLeft = !(x < 0 && !(onZ >= 0.5) || x > 0 && !(onZ <= 0.5) || z < 0 && !(onX <= 0.5) || z > 0 && !(onX >= 0.5));
        boolean powered = world.m_276867_(pos) || world.m_276867_(pos.m_7494_());
        BlockState madeState = (BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_(HINGE, (Comparable)(hingeLeft ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT))).m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
        return (BlockState)madeState.m_61124_(OPEN_POSITION, (Comparable)((Object)(powered ? this.getOpenState(madeState, (LevelAccessor)world, pos) : BlockStatePropertiesAA.OpenPosition.CLOSED)));
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction hingeDirection;
        Direction direction = (Direction)stateIn.m_61143_((Property)FACING);
        Direction direction2 = hingeDirection = stateIn.m_61143_(HINGE) == DoorHingeSide.LEFT ? direction.m_122428_() : direction.m_122427_();
        if (facing == hingeDirection) {
            return (stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos)).m_61143_(OPEN_POSITION) == BlockStatePropertiesAA.OpenPosition.CLOSED ? stateIn : (BlockState)stateIn.m_61124_(OPEN_POSITION, (Comparable)((Object)this.getOpenState(stateIn, worldIn, facingPos)));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((BlockStatePropertiesAA.OpenPosition)((Object)state.m_61143_(OPEN_POSITION))).isOpen()) {
            state = (BlockState)state.m_61124_(OPEN_POSITION, (Comparable)((Object)BlockStatePropertiesAA.OpenPosition.CLOSED));
        } else {
            Direction hingeDirection = state.m_61143_(HINGE) == DoorHingeSide.LEFT ? ((Direction)state.m_61143_((Property)FACING)).m_122428_() : ((Direction)state.m_61143_((Property)FACING)).m_122427_();
            state = (BlockState)state.m_61124_(OPEN_POSITION, (Comparable)((Object)this.getOpenState(state, (LevelAccessor)worldIn, pos.m_121945_(hingeDirection))));
        }
        worldIn.m_7731_(pos, state, 10);
        worldIn.m_5898_(player, ((BlockStatePropertiesAA.OpenPosition)((Object)state.m_61143_(OPEN_POSITION))).isOpen() ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        if (((Boolean)state.m_61143_((Property)WaterloggedBlock.WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isPowered = worldIn.m_276867_(pos);
        if (blockIn != this && isPowered != (Boolean)state.m_61143_((Property)POWERED)) {
            if (isPowered != ((BlockStatePropertiesAA.OpenPosition)((Object)state.m_61143_(OPEN_POSITION))).isOpen()) {
                this.playSound(worldIn, pos, isPowered);
            }
            if (isPowered) {
                Direction hingeDirection = state.m_61143_(HINGE) == DoorHingeSide.LEFT ? ((Direction)state.m_61143_((Property)FACING)).m_122428_() : ((Direction)state.m_61143_((Property)FACING)).m_122427_();
                state = (BlockState)state.m_61124_(OPEN_POSITION, (Comparable)((Object)this.getOpenState(state, (LevelAccessor)worldIn, pos.m_121945_(hingeDirection))));
            } else {
                state = (BlockState)state.m_61124_(OPEN_POSITION, (Comparable)((Object)BlockStatePropertiesAA.OpenPosition.CLOSED));
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 2);
        }
    }

    protected BlockStatePropertiesAA.OpenPosition getOpenState(BlockState stateIn, LevelAccessor worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_60812_((BlockGetter)worldIn, pos).m_83281_() ? BlockStatePropertiesAA.OpenPosition.FULL : BlockStatePropertiesAA.OpenPosition.HALF;
    }

    private void playSound(Level worldIn, BlockPos pos, boolean isOpening) {
        worldIn.m_5898_(null, isOpening ? this.getOpenSound() : this.getCloseSound(), pos, 0);
    }

    private int getCloseSound() {
        return 1012;
    }

    private int getOpenSound() {
        return 1006;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            default: {
                return state;
            }
            case FRONT_BACK: {
                state = this.m_6843_(state, Rotation.CLOCKWISE_180);
            }
            case LEFT_RIGHT: 
        }
        return (BlockState)state.m_61124_(HINGE, (Comparable)(state.m_61143_(HINGE) == DoorHingeSide.RIGHT ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT));
    }

    public int m_7753_(BlockState p_200011_1_In, BlockGetter p_200011_2_In, BlockPos p_200011_3_In) {
        return 1;
    }

    public boolean m_7923_(BlockState p_220074_1_In) {
        return false;
    }

    public VoxelShape m_7952_(BlockState p_196247_1_In, BlockGetter p_196247_2_In, BlockPos p_196247_3_In) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState p_200123_1_In, BlockGetter p_200123_2_In, BlockPos p_200123_3_In) {
        return true;
    }
}

