/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.util;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.jetbrains.annotations.NotNull;

public class BlockStatePropertiesAA {
    public static final BooleanProperty ROLLED = BooleanProperty.m_61465_((String)"rolled");
    public static final BooleanProperty AXIS_X = BooleanProperty.m_61465_((String)"axis_x");
    public static final BooleanProperty AXIS_Y = BooleanProperty.m_61465_((String)"axis_y");
    public static final BooleanProperty AXIS_Z = BooleanProperty.m_61465_((String)"axis_z");
    public static final BooleanProperty SUBAXIS = BooleanProperty.m_61465_((String)"subaxis");
    public static final BooleanProperty HAS_PILLAR = BooleanProperty.m_61465_((String)"has_pillar");
    public static final BooleanProperty CENTER = BooleanProperty.m_61465_((String)"center");
    public static final BooleanProperty NORTH_TRICKLE = BooleanProperty.m_61465_((String)"north_trickle");
    public static final BooleanProperty EAST_TRICKLE = BooleanProperty.m_61465_((String)"east_trickle");
    public static final BooleanProperty SOUTH_TRICKLE = BooleanProperty.m_61465_((String)"south_trickle");
    public static final BooleanProperty WEST_TRICKLE = BooleanProperty.m_61465_((String)"west_trickle");
    public static final BooleanProperty CENTER_TRICKLE = BooleanProperty.m_61465_((String)"center_trickle");
    public static final BooleanProperty ACTIVATED = BooleanProperty.m_61465_((String)"activated");
    public static final BooleanProperty SMALL_TOP = BooleanProperty.m_61465_((String)"small_top");
    public static final IntegerProperty MULTIBLOCK_0_2 = IntegerProperty.m_61631_((String)"multiblock", (int)0, (int)2);
    public static final IntegerProperty MULTIBLOCK_3X = IntegerProperty.m_61631_((String)"multiblock_3x", (int)0, (int)2);
    public static final IntegerProperty MULTIBLOCK_2Y = IntegerProperty.m_61631_((String)"multiblock_2y", (int)0, (int)1);
    public static final IntegerProperty MULTIBLOCK_3Z = IntegerProperty.m_61631_((String)"multiblock_3z", (int)0, (int)2);
    public static final IntegerProperty HUMIDITY_0_8 = IntegerProperty.m_61631_((String)"humidity", (int)0, (int)8);
    public static final IntegerProperty HEAT_0_4 = IntegerProperty.m_61631_((String)"heat", (int)0, (int)4);
    public static final IntegerProperty STACK = IntegerProperty.m_61631_((String)"stack", (int)1, (int)3);
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)16);
    public static final EnumProperty<FencePillar> FENCE_PILLAR = EnumProperty.m_61587_((String)"fence_pillar", FencePillar.class);
    public static final EnumProperty<HorizontalConnection> HORIZONTAL_CONNECTION = EnumProperty.m_61587_((String)"horizontal_connection", HorizontalConnection.class);
    public static final EnumProperty<OpenPosition> OPEN_POSITION = EnumProperty.m_61587_((String)"open_position", OpenPosition.class);
    public static final EnumProperty<PillarConnection> PILLAR_CONNECTION = EnumProperty.m_61587_((String)"pillar_connection", PillarConnection.class);
    public static final EnumProperty<VerticalConnection> VERTICAL_CONNECTION = EnumProperty.m_61587_((String)"vertical_connection", VerticalConnection.class);
    public static final EnumProperty<SquareCorners> CORNER = EnumProperty.m_61587_((String)"corner", SquareCorners.class);
    public static final EnumProperty<WallSide> PILLAR_WALL = EnumProperty.m_61587_((String)"pillar", WallSide.class);
    public static final EnumProperty<VerticalLimitedConnection> NORTH_STATE = EnumProperty.m_61587_((String)"north_state", VerticalLimitedConnection.class);
    public static final EnumProperty<VerticalLimitedConnection> EAST_STATE = EnumProperty.m_61587_((String)"east_state", VerticalLimitedConnection.class);
    public static final EnumProperty<VerticalLimitedConnection> SOUTH_STATE = EnumProperty.m_61587_((String)"south_state", VerticalLimitedConnection.class);
    public static final EnumProperty<VerticalLimitedConnection> WEST_STATE = EnumProperty.m_61587_((String)"west_state", VerticalLimitedConnection.class);
    public static final EnumProperty<WaterTrickleEnd> WATER_TRICKLE_END = EnumProperty.m_61587_((String)"water_end", WaterTrickleEnd.class);

    public static enum FencePillar implements StringRepresentable
    {
        NONE("none"),
        PILLAR_BIG("pillar_big"),
        PILLAR_SMALL("pillar_small"),
        CAP_PILLAR_BIG("cap_pillar_big");

        private final String name;

        private FencePillar(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }

    public static enum HorizontalConnection implements StringRepresentable
    {
        NONE("none", 0),
        LEFT("left", 1),
        RIGHT("right", 2),
        BOTH("both", 3);

        private final String name;
        private final int index;

        private HorizontalConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum OpenPosition implements StringRepresentable
    {
        CLOSED("closed"),
        HALF("half"),
        FULL("full");

        private final String name;

        private OpenPosition(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public boolean isOpen() {
            return this != CLOSED;
        }
    }

    public static enum PillarConnection implements StringRepresentable
    {
        NOTHING("nothing"),
        FOUR_PX("4_pixels"),
        SIX_PX("6_pixels"),
        EIGHT_PX("8_pixels"),
        TEN_PX("10_pixels");

        private final String name;

        private PillarConnection(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }

    public static enum VerticalConnection implements StringRepresentable
    {
        NONE("none", 0),
        UNDER("under", 1),
        ABOVE("above", 2),
        BOTH("both", 3);

        private final String name;
        private final int index;

        private VerticalConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum SquareCorners implements StringRepresentable
    {
        TOP_LEFT("top_left", -1, 1),
        TOP_RIGHT("top_right", 1, 1),
        BOTTOM_RIGHT("bottom_right", 1, -1),
        BOTTOM_LEFT("bottom_left", -1, -1);

        private final String name;
        private final int horizontal_offset;
        private final int vertical_offset;

        private SquareCorners(String name, int horizontal_offset, int vertical_offset) {
            this.name = name;
            this.horizontal_offset = horizontal_offset;
            this.vertical_offset = vertical_offset;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public int getHorizontalOffset(SquareCorners referenceCorner) {
            return referenceCorner.horizontal_offset == this.horizontal_offset ? 0 : this.horizontal_offset;
        }

        public int getVerticalOffset(SquareCorners referenceCorner) {
            return referenceCorner.vertical_offset == this.vertical_offset ? 0 : this.vertical_offset;
        }

        public boolean isTopCorner() {
            return this.vertical_offset == 1;
        }

        public SquareCorners getAdjacentCorner(boolean vertically) {
            return switch (this) {
                case TOP_RIGHT -> {
                    if (vertically) {
                        yield BOTTOM_RIGHT;
                    }
                    yield TOP_LEFT;
                }
                case BOTTOM_RIGHT -> {
                    if (vertically) {
                        yield TOP_RIGHT;
                    }
                    yield BOTTOM_LEFT;
                }
                case BOTTOM_LEFT -> {
                    if (vertically) {
                        yield TOP_LEFT;
                    }
                    yield BOTTOM_RIGHT;
                }
                default -> vertically ? BOTTOM_LEFT : TOP_RIGHT;
            };
        }
    }

    public static enum VerticalLimitedConnection implements StringRepresentable
    {
        NONE("none", 0),
        BOTTOM("bottom", 1),
        TOP("top", 2);

        private final String name;
        private final int index;

        private VerticalLimitedConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum WaterTrickleEnd implements StringRepresentable
    {
        STRAIGHT("straight"),
        FADE("fade"),
        SPLASH("splash");

        private final String name;

        private WaterTrickleEnd(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

