/*
 * Decompiled with CFR 0.152.
 */
package net.nukebob.silksong;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.nukebob.silksong.common.attachment.SilksongAttachmentTypes;
import net.nukebob.silksong.common.component.SilksongComponents;
import net.nukebob.silksong.common.entity.SilksongEntityTypes;
import net.nukebob.silksong.common.item.SilksongItemGroups;
import net.nukebob.silksong.common.item.SilksongItems;
import net.nukebob.silksong.common.networking.SilksongNetworking;
import net.nukebob.silksong.common.networking.SilksongPayloads;
import net.nukebob.silksong.common.particle.SilksongParticleTypes;
import net.nukebob.silksong.common.potion.HornetEffect;
import net.nukebob.silksong.common.sound.SilksongSounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Silksong
implements ModInitializer {
    public static final String MOD_ID = "silksong";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"silksong");

    public void onInitialize() {
        SilksongItems.register();
        SilksongItemGroups.register();
        HornetEffect.register();
        SilksongParticleTypes.register();
        SilksongPayloads.registerPayloads();
        SilksongNetworking.registerServerPackets();
        SilksongAttachmentTypes.register();
        SilksongComponents.register();
        SilksongEntityTypes.register();
        SilksongSounds.register();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (!player.method_6059(HornetEffect.HORNET_EFFECT)) continue;
                if (player.method_24828()) {
                    player.setAttached(SilksongAttachmentTypes.DASH_HAS_TOUCHED_GROUND, (Object)true);
                }
                if (!Boolean.TRUE.equals(player.getAttached(SilksongAttachmentTypes.DASH_HAS_TOUCHED_GROUND))) continue;
                int dashCooldown = (Integer)player.getAttachedOrElse(SilksongAttachmentTypes.DASH_COOLDOWN_ATTACHMENT, (Object)0);
                boolean hasTouchedGround = (Boolean)player.getAttachedOrElse(SilksongAttachmentTypes.DASH_HAS_TOUCHED_GROUND, (Object)false);
                if (hasTouchedGround) {
                    player.setAttached(SilksongAttachmentTypes.DASH_COOLDOWN_ATTACHMENT, (Object)(dashCooldown - 1));
                }
                if (dashCooldown != 0) continue;
                player.setAttached(SilksongAttachmentTypes.DASH_COOLDOWN_ATTACHMENT, (Object)0);
            }
            for (class_3218 world : server.method_3738()) {
                for (class_1297 iterateEntity : world.method_27909()) {
                    class_1542 item;
                    if (!(iterateEntity instanceof class_1542) || !(item = (class_1542)iterateEntity).method_6983().method_31574(SilksongItems.NEEDLE)) continue;
                    class_1799 stack = item.method_6983();
                    stack.method_57379(SilksongComponents.NEEDLE_FRAME, null);
                    stack.method_57379(SilksongComponents.NEEDLE_THROWN, null);
                    item.method_6979(stack);
                }
            }
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> {
            if (((Boolean)player.method_5998(hand).method_58695(SilksongComponents.NEEDLE_THROWN, (Object)false)).booleanValue()) {
                return class_1269.field_5814;
            }
            if (player.method_5998(class_1268.field_5808).method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"needles")))) {
                player.setAttached(SilksongAttachmentTypes.DASH_COOLDOWN_ATTACHMENT, (Object)0);
                player.setAttached(SilksongAttachmentTypes.DASH_HAS_TOUCHED_GROUND, (Object)true);
            }
            return class_1269.field_5811;
        });
        LOGGER.info("HK Silksong by Nukebob initialized!");
    }
}

