/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.client.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.zeus.sp.SP;
import net.zeus.sp.client.ClientData;
import net.zeus.sp.client.screen.widgets.SelectionButton;
import net.zeus.sp.config.SPClientConfig;
import net.zeus.sp.level.block.SPBlocks;
import net.zeus.sp.level.block.entities.CameraBlockEntity;
import net.zeus.sp.level.item.SPItems;
import net.zeus.sp.level.item.items.MapperItem;
import net.zeus.sp.level.item.items.Tablet;
import net.zeus.sp.networking.C2S.HandleModulePacket;
import net.zeus.sp.networking.C2S.LockCameraPacket;
import net.zeus.sp.networking.C2S.RequestCameraInfoPacket;
import net.zeus.sp.networking.C2S.SelectCameraPacket;
import net.zeus.sp.networking.C2S.SyncMapRotation;
import net.zeus.sp.networking.C2S.UpdateCameraPacket;
import net.zeus.sp.networking.SPMessages;
import net.zeus.sp.util.Keybindings;

public class SelectCameraScreen
extends Screen {
    protected final InteractionHand hand;
    protected final int cameras;
    protected static final ResourceLocation SELECTION = new ResourceLocation("sp", "screen/selection/selection.png");
    protected static final ResourceLocation SELECTION_MIN = new ResourceLocation("sp", "screen/selection/selection_min.png");
    protected static final ResourceLocation SCROLL_BAR = new ResourceLocation("sp", "screen/selection/scroll_bar.png");
    protected static final ResourceLocation CAM_OVERLAY = new ResourceLocation("sp", "screen/selection/cam_overlay.png");
    protected static final ResourceLocation CAM_OVERLAY_LOCKED = new ResourceLocation("sp", "screen/selection/cam_overlay_locked.png");
    protected static final ResourceLocation CAM = new ResourceLocation("sp", "screen/selection/cam.png");
    protected static final ResourceLocation BLOCK = new ResourceLocation("sp", "screen/selection/block.png");
    protected static final ResourceLocation CAM_UNSELECTED = new ResourceLocation("sp", "screen/selection/cam_unselected.png");
    protected static final ResourceLocation CAM_SELECTED = new ResourceLocation("sp", "screen/selection/cam_selected.png");
    protected static final ResourceLocation CAM_MOTION = new ResourceLocation("sp", "screen/selection/cam_motion.png");
    protected static final List<ResourceLocation> STATIC_OVERLAYS = List.of(new ResourceLocation("sp", "screen/selection/static_1.png"), new ResourceLocation("sp", "screen/selection/static_2.png"), new ResourceLocation("sp", "screen/selection/static_3.png"), new ResourceLocation("sp", "screen/selection/static_4.png"));
    protected static final int staticChangeInterval = 5;
    protected int staticIndex = 0;
    protected int staticTicks;
    protected final HashMap<SelectionButton, Integer> BUTTONS = new HashMap();
    protected int scrollIndex = 0;
    protected int maxScrollIndex = 0;
    protected final int maxScrollBarY = this.f_96544_ - 4;
    protected final int minScrollBarY = this.f_96544_ - 98;
    protected int currentCam = 0;
    protected boolean minimized = false;
    protected Pair<Integer, Integer> minimizeButton = Pair.of((Object)0, (Object)0);
    protected int tickCount = 0;
    private boolean cameraFlipped = false;
    private boolean cameraSwitching = false;
    public boolean refreshButtons = false;
    protected Pair<BlockState, BlockPos>[][] blocks = null;
    protected HashMap<BlockPos, Pair<Integer, Integer>> cameraMap = new HashMap();
    protected boolean built = false;
    protected HashMap<CameraBlockEntity.Module, SelectionButton> moduleButtons = new HashMap();
    private int rotateCooldown = 0;
    private int moduleCooldown = 0;
    private final int guiScale;
    private final ItemStack stack;

    public SelectCameraScreen(InteractionHand hand, ItemStack stack, int cameras, int guiScale) {
        super((Component)Component.m_237119_());
        this.hand = hand;
        this.stack = stack;
        this.cameras = cameras;
        this.staticTicks = 5;
        this.guiScale = guiScale;
    }

    protected void m_7856_() {
        AABB mapData;
        this.blocks = null;
        ItemStack stack = this.stack;
        if (stack.m_150930_((Item)SPItems.TABLET.get()) && (mapData = Tablet.getMapData(stack)) != null) {
            this.blocks = MapperItem.getBlocks(mapData, this.stack, ClientData.getPlayer().m_9236_());
        }
        CompoundTag tag = stack.m_41784_();
        if (!this.built) {
            this.rotateMap(tag.m_128451_("map_rot") + 1);
        }
        ClientData.cameraData.clear();
        ClientData.existingCameras.clear();
        for (int i = 0; i < this.cameras; ++i) {
            ClientData.existingCameras.put(i, false);
            SPMessages.sendToServer(new RequestCameraInfoPacket(this.hand, i, i == this.cameras - 1));
            if (this.blocks != null) continue;
            int y = i % 5;
            SelectionButton button = this.createButton(this.f_96543_ - 107, this.f_96544_ - 98 + 19 * y - 20, 61, 17, i, ClientData.cameraData.getOrDefault(i, new ClientData.CameraData(i, null, (Component)Component.m_237113_((String)"CAM %s%d".formatted(i + 1 < 10 ? "0" : "", i + 1)), 0.0f)).customName());
            this.BUTTONS.put(button, i);
            if (i != 0) continue;
            button.isSelected = true;
        }
        this.BUTTONS.keySet().stream().sorted(Comparator.comparing(this.BUTTONS::get)).limit(5L).forEach(x$0 -> {
            SelectionButton cfr_ignored_0 = (SelectionButton)this.m_142416_((GuiEventListener)x$0);
        });
        this.maxScrollIndex = this.BUTTONS.size() - 5;
        this.minimizeButton = Pair.of((Object)(this.f_96543_ - 44), (Object)(this.f_96544_ - 125));
        this.built = true;
    }

    public void resetModuleButtons() {
        this.moduleButtons.forEach((module, button) -> {
            module.getItem().enabled = false;
            this.m_169411_((GuiEventListener)button);
        });
        this.moduleButtons.clear();
    }

    protected void onCameraSwitch() {
        this.resetModuleButtons();
        Minecraft.m_91087_().f_91063_.m_109106_(null);
    }

    protected void m_232761_() {
        this.BUTTONS.keySet().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.BUTTONS.clear();
        super.m_232761_();
    }

    public void m_86600_() {
        if (this.refreshButtons) {
            this.refreshButtons = false;
            this.refreshButtons();
        }
        ++this.tickCount;
        if (this.staticTicks > 0) {
            --this.staticTicks;
        }
        if (this.cameraSwitching && this.staticTicks == 1) {
            this.cameraSwitching = false;
        }
        if (ClientData.currentCamera != null && ClientData.currentCameraEntity != null && (!ClientData.controller || ClientData.currentCamera.panning)) {
            ClientData.currentCameraEntity.f_20885_ = ClientData.currentCamera.yRot;
            ClientData.currentCameraEntity.m_146926_(ClientData.currentCamera.xRot);
        }
        if (this.rotateCooldown > 0) {
            --this.rotateCooldown;
        }
        if (this.moduleCooldown > 0) {
            --this.moduleCooldown;
        } else if (!this.moduleButtons.isEmpty()) {
            this.moduleButtons.forEach((module, button) -> {
                button.f_93623_ = true;
            });
        }
        if (ClientData.currentCamera == null) {
            return;
        }
        this.moduleButtons.forEach((module, button) -> {
            if (!ClientData.currentCamera.modules.contains(module)) {
                this.m_169411_((GuiEventListener)button);
            }
        });
        for (CameraBlockEntity.Module module2 : ClientData.currentCamera.modules) {
            PostChain chain = Minecraft.m_91087_().f_91063_.m_109149_();
            boolean gray = ClientData.currentCamera.modules.contains((Object)CameraBlockEntity.Module.LENS);
            if (module2.getItem().getShader(gray) != null && (chain == null || !chain.m_110022_().equals(module2.getItem().getShader(gray).toString())) && module2.getItem().enabled) {
                Minecraft.m_91087_().f_91063_.m_109128_(module2.getItem().getShader(gray));
                continue;
            }
            if (chain == null || module2.getItem().getShader(gray) == null || !chain.m_110022_().equals(module2.getItem().getShader(gray).toString()) || module2.getItem().enabled) continue;
            if (ClientData.currentCamera.modules.contains((Object)CameraBlockEntity.Module.LENS)) {
                Minecraft.m_91087_().f_91063_.m_109128_(new ResourceLocation("sp", "shaders/grayscale.json"));
                return;
            }
            Minecraft.m_91087_().f_91063_.m_109106_(null);
        }
    }

    public void refreshButtons() {
        if (this.blocks == null) {
            ClientData.existingCameras.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).forEach(entry -> this.removeButton((Integer)entry.getKey()));
            return;
        }
        this.makeMapButtons();
    }

    private int mapScale() {
        int maxWidth = MapperItem.maxSize();
        int maxMapScale = 8 - (this.guiScale() > 2 ? 7 - this.guiScale() : 0);
        int xWidth = this.blocks.length;
        int zWidth = this.blocks[0].length;
        int max = Math.max(xWidth, zWidth);
        int scale = (int)Math.ceil((float)maxWidth / (float)max);
        return Math.min(scale, maxMapScale);
    }

    private int guiScale() {
        return (int)Minecraft.m_91087_().m_91268_().m_85449_();
    }

    private int mapYOffset() {
        return this.guiScale() > 2 ? 23 : 0;
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.tickCount <= 6 && !this.cameraFlipped) {
            return;
        }
        this.flipCamera();
        this.renderStatic(guiGraphics);
        this.renderOverlay(guiGraphics);
        if (this.blocks != null) {
            if (this.cameraMap == null || this.cameraMap.isEmpty()) {
                this.refreshButtons = true;
            }
            this.cameraMap = this.renderMap(guiGraphics, pMouseX, pMouseY);
        } else {
            this.renderSelection(guiGraphics);
        }
        this.renderModules(guiGraphics, false);
        for (Renderable renderable : this.f_169369_) {
            if (renderable instanceof SelectionButton) {
                SelectionButton selectionButton = (SelectionButton)renderable;
                if (selectionButton.isMapButton && !((Boolean)SPClientConfig.USE_OLD_CAMERA_GUI.get()).booleanValue()) continue;
            }
            renderable.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        this.renderModules(guiGraphics, true);
        RenderSystem.disableBlend();
        if (ClientData.currentCamera != null && ClientData.currentCamera.customName != null && !Objects.equals(ClientData.currentCamera.customName, Component.m_237119_())) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
            guiGraphics.m_280168_().m_85837_((double)(-this.f_96543_) / 2.0, 0.0, 0.0);
            guiGraphics.m_280653_(this.f_96547_, ClientData.currentCamera.customName, this.f_96543_ - this.f_96543_ / 4, 25, 0xFFFFFF);
            guiGraphics.m_280168_().m_85849_();
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
        guiGraphics.m_280168_().m_85837_((double)(-this.f_96543_) / 2.0, 0.0, 0.0);
        guiGraphics.m_280488_(this.f_96547_, SelectCameraScreen.convertGameTimeToAMPM(Minecraft.m_91087_().f_91073_.m_46468_()), this.f_96543_ - 37, 10, 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
    }

    public void rotateMap(int times) {
        if (this.blocks == null) {
            return;
        }
        Pair[][] newBlocks = new Pair[this.blocks[0].length][this.blocks.length];
        for (int x = 0; x < this.blocks.length; ++x) {
            for (int z = 0; z < this.blocks[x].length; ++z) {
                newBlocks[z][this.blocks.length - x - 1] = this.blocks[x][z];
            }
        }
        this.blocks = newBlocks;
        this.refreshButtons = true;
        if (times > 1) {
            this.rotateMap(times - 1);
        }
    }

    public HashMap<BlockPos, Pair<Integer, Integer>> renderMap(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        HashMap<BlockPos, Pair<Integer, Integer>> map = new HashMap<BlockPos, Pair<Integer, Integer>>();
        int topMostX = this.f_96543_ - 50 - this.blocks.length * this.mapScale();
        int topMostY = this.f_96544_ - this.blocks[0].length * this.mapScale() - 30 + this.mapYOffset();
        int size = this.mapScale();
        boolean transparent = mouseX >= topMostX && mouseX <= topMostX + this.blocks.length * size && mouseY >= topMostY && mouseY <= topMostY + this.blocks[0].length * size;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(!transparent ? 0.5f : 1.0f));
        for (int x1 = 0; x1 < this.blocks.length; ++x1) {
            for (int z1 = 0; z1 < this.blocks[x1].length; ++z1) {
                CameraBlockEntity cameraBlockEntity;
                CameraBlockEntity posEntity;
                BlockState state = (BlockState)this.blocks[x1][z1].getFirst();
                if (state == null || state.m_60795_()) continue;
                int xPos = this.f_96543_ - 50 - this.blocks.length * size + x1 * size;
                int yPos = this.f_96544_ - this.blocks[x1].length * size - 30 + z1 * size + this.mapYOffset();
                BlockEntity blockEntity = ClientData.getPlayer().m_9236_().m_7702_((BlockPos)this.blocks[x1][z1].getSecond());
                CameraBlockEntity cameraBlockEntity2 = posEntity = blockEntity instanceof CameraBlockEntity ? (cameraBlockEntity = (CameraBlockEntity)blockEntity) : null;
                if (posEntity != null && ClientData.cameraData.entrySet().stream().anyMatch(d -> ((ClientData.CameraData)d.getValue()).entity() != null && ((Object)((Object)((ClientData.CameraData)d.getValue()).entity())).equals((Object)posEntity)) && !((Boolean)SPClientConfig.USE_OLD_CAMERA_GUI.get()).booleanValue()) {
                    PoseStack poseStack = guiGraphics.m_280168_();
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    ResourceLocation texture = posEntity.motionDetected() && posEntity.modules.contains((Object)CameraBlockEntity.Module.MOTION) ? CAM_MOTION : (((Object)((Object)posEntity)).equals((Object)ClientData.currentCamera) ? CAM_SELECTED : CAM_UNSELECTED);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
                    poseStack.m_85836_();
                    float rotationAngle = posEntity.yRot - (float)(this.stack.m_41784_().m_128451_("map_rot") * 90);
                    poseStack.m_252880_((float)((xPos -= 22) + 26), (float)((yPos -= 2) + 6), 20.0f);
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(rotationAngle));
                    poseStack.m_252880_((float)(-xPos - 6), (float)(-yPos - 6), 0.0f);
                    guiGraphics.m_280163_(texture, xPos, yPos - 2, 0.0f, 0.0f, 32, 16, 32, 16);
                    poseStack.m_85849_();
                } else {
                    guiGraphics.m_280398_(state.m_60713_((Block)SPBlocks.CAMERA.get()) ? CAM : BLOCK, xPos, yPos, 0, 0.0f, 0.0f, size, size, 4, 4);
                }
                if (!state.m_60713_((Block)SPBlocks.CAMERA.get())) continue;
                map.put((BlockPos)this.blocks[x1][z1].getSecond(), (Pair<Integer, Integer>)Pair.of((Object)x1, (Object)z1));
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return map;
    }

    public void makeMapButtons() {
        if (this.cameraMap.isEmpty()) {
            return;
        }
        this.BUTTONS.keySet().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.BUTTONS.clear();
        int size = this.mapScale();
        ClientData.cameraData.forEach((p, data) -> {
            Pair<BlockState, BlockPos>[][] pairArray = this.blocks;
            int n = pairArray.length;
            for (int i = 0; i < n; ++i) {
                Pair<BlockState, BlockPos>[] block;
                for (Pair<BlockState, BlockPos> pair : block = pairArray[i]) {
                    CameraBlockEntity cameraBlockEntity;
                    BlockEntity blockEntity = ClientData.getPlayer().m_9236_().m_7702_((BlockPos)pair.getSecond());
                    CameraBlockEntity posEntity = blockEntity instanceof CameraBlockEntity ? (cameraBlockEntity = (CameraBlockEntity)blockEntity) : null;
                    CameraBlockEntity dataEntity = data.entity();
                    Pair<Integer, Integer> pos = this.cameraMap.get(pair.getSecond());
                    if (posEntity == null || (Integer)pos.getFirst() >= this.blocks.length || dataEntity == null || !posEntity.m_58899_().equals((Object)dataEntity.m_58899_())) continue;
                    int xPos = this.f_96543_ - 50 - this.blocks.length * size + (Integer)pos.getFirst() * size - 22;
                    int yPos = this.f_96544_ - this.blocks[(Integer)pos.getFirst()].length * size - 30 + (Integer)pos.getSecond() * size - 3 + this.mapYOffset();
                    boolean show = (Boolean)SPClientConfig.SHOW_BUTTON_NAMES.get() != false && (Boolean)SPClientConfig.USE_OLD_CAMERA_GUI.get() != false;
                    SelectionButton button = this.createButton(xPos + (show ? 0 : 18), yPos, show ? 37 : 12, show ? 17 : 12, data.id(), (Component)(show ? data.customName() : Component.m_237113_((String)String.valueOf(data.id()))));
                    button.isMapButton = true;
                    this.BUTTONS.put(button, data.id());
                    return;
                }
            }
        });
        this.BUTTONS.keySet().forEach(x$0 -> {
            SelectionButton cfr_ignored_0 = (SelectionButton)this.m_142416_((GuiEventListener)x$0);
        });
        this.BUTTONS.entrySet().stream().filter(entry -> (Integer)entry.getValue() == this.currentCam).findFirst().ifPresent(entry -> {
            ((SelectionButton)((Object)((Object)entry.getKey()))).isSelected = true;
        });
    }

    public SelectionButton createButton(int xPos, int yPos, int width, int height, Component customName, Button.OnPress onPress) {
        return SelectionButton.buttonBuilder(customName, onPress).pos(xPos, yPos).size(width, height).build();
    }

    public SelectionButton createButton(int xPos, int yPos, int width, int height, int id, Component customName) {
        return this.createButton(xPos, yPos, width, height, customName, onPress -> {
            this.staticTicks = 5;
            SPMessages.sendToServer(new SelectCameraPacket(id, this.hand));
            this.cameraSwitching = true;
            this.BUTTONS.entrySet().stream().filter(entry -> (Integer)entry.getValue() == this.currentCam).findFirst().ifPresent(entry -> {
                ((SelectionButton)((Object)((Object)((Object)entry.getKey())))).isSelected = false;
            });
            this.currentCam = id;
            this.BUTTONS.entrySet().stream().filter(entry -> (Integer)entry.getValue() == this.currentCam).findFirst().ifPresent(entry -> {
                ((SelectionButton)((Object)((Object)((Object)entry.getKey())))).isSelected = true;
            });
            this.onCameraSwitch();
        });
    }

    public void renderSelection(GuiGraphics guiGraphics) {
        if (!this.minimized) {
            guiGraphics.m_280398_(SELECTION, this.f_96543_ - 112, this.f_96544_ - 112 - this.getYOffset(), 0, 0.0f, 0.0f, 87, 112, 87, 112);
        } else {
            guiGraphics.m_280398_(SELECTION_MIN, this.f_96543_ - 112, this.f_96544_ - 15 - this.getYOffset(), 0, 0.0f, 0.0f, 87, 15, 87, 15);
        }
        if (!this.minimized) {
            guiGraphics.m_280411_(SCROLL_BAR, this.f_96543_ - 43, this.f_96544_ - 97 + (int)((float)Math.min(this.scrollIndex, this.maxScrollIndex) / (float)this.maxScrollIndex * (float)(this.maxScrollBarY - this.minScrollBarY - 18)) - this.getYOffset(), 12, 15, 0.0f, 0.0f, 12, 15, 12, 15);
        }
    }

    public void renderModules(GuiGraphics guiGraphics, boolean post) {
        if (ClientData.currentCamera == null) {
            return;
        }
        AtomicInteger count = new AtomicInteger();
        this.moduleButtons.entrySet().removeIf(entry -> !ClientData.currentCamera.modules.contains(entry.getKey()));
        this.moduleButtons.forEach((module, button) -> {
            int y = 57 + count.getAndIncrement() * 50;
            if (!post) {
                guiGraphics.m_280163_(module.getItem().getFrame(), 50, this.f_96544_ - y, 0.0f, 0.0f, 77, 39, 77, 39);
            }
        });
        count.set(0);
        for (CameraBlockEntity.Module module2 : ClientData.currentCamera.modules) {
            if (module2 == null || module2.equals((Object)CameraBlockEntity.Module.NONE) || this.staticScreen() || !module2.getItem().hasFrame()) continue;
            int y = 57 + count.getAndIncrement() * 50;
            if (!this.moduleButtons.containsKey((Object)module2)) {
                if (module2.getItem().getShader(false) != null && SP.hasOptifine) continue;
                this.moduleButtons.put(module2, this.createButton(58, this.f_96544_ - y + 15, 62, 17, (Component)Component.m_237119_(), onPress -> {
                    if (this.moduleCooldown <= 0) {
                        module.getItem().enabled = !module.getItem().enabled;
                        this.moduleButtons.get((Object)((Object)((Object)module))).isSelected = module.getItem().enabled;
                        this.moduleButtons.get((Object)((Object)((Object)module))).f_93623_ = false;
                        if (module2.getItem().getSound() != null && module.getItem().enabled && ClientData.currentCameraEntity != null) {
                            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityBoundSoundInstance(module2.getItem().getSound(), SoundSource.BLOCKS, 1.0f, 1.0f, (Entity)ClientData.currentCameraEntity, RandomSource.m_216327_().m_188505_()));
                        }
                        this.moduleCooldown = 15;
                        SPMessages.sendToServer(new HandleModulePacket(module2));
                    }
                }));
                this.m_142416_((GuiEventListener)this.moduleButtons.get((Object)module2));
                this.moduleButtons.get((Object)((Object)module2)).f_93623_ = true;
                module2.getItem().enabled = false;
            }
            guiGraphics.m_280398_(module2.getItem().enabled ? module2.getItem().getOn() : module2.getItem().getOff(), 80, this.f_96544_ - y + 15, 0, 0.0f, 0.0f, 17, 17, 17, 17);
        }
    }

    public void renderStatic(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172820_);
        boolean staticScreen = this.staticScreen();
        MutableComponent cam = Component.m_237113_((String)"CAM %s%d CONNECTED".formatted(this.currentCam + 1 < 10 ? "0" : "", this.currentCam + 1)).m_130940_(ChatFormatting.GREEN);
        if (this.tickCount % 5 == 0) {
            this.staticIndex = (this.staticIndex + 1) % (STATIC_OVERLAYS.size() - 1);
        }
        if (staticScreen) {
            cam = Component.m_237113_((String)"SIGNAL JAMMED").m_130940_(ChatFormatting.YELLOW);
            if (this.cameras <= 0) {
                cam = Component.m_237113_((String)"NO CAMERAS FOUND").m_130940_(ChatFormatting.RED);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.cameras <= 0 || this.cameraSwitching || ClientData.currentCamera == null || ClientData.currentCamera.hidden ? 1.0f : 0.3f));
            if (ClientData.getPlayer().m_217043_().m_188501_() > 0.99999f) {
                this.staticIndex = 3;
            }
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(ClientData.currentCameraEntity == null ? 1.0f : 0.12f));
        }
        if (this.staticIndex == 3) {
            guiGraphics.m_280411_(STATIC_OVERLAYS.get(this.staticIndex - 1), 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 164, 82, 164, 82);
        }
        guiGraphics.m_280411_(STATIC_OVERLAYS.get(this.staticIndex), 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 164, 82, 164, 82);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280653_(this.f_96547_, (Component)cam, this.f_96543_ / 2, 20, 0xFFFFFF);
    }

    public void renderOverlay(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172820_);
        if (ClientData.currentCamera != null && ClientData.currentCamera.moveable) {
            guiGraphics.m_280411_(CAM_OVERLAY, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 164, 82, 164, 82);
        } else if (ClientData.currentCamera != null) {
            guiGraphics.m_280411_(CAM_OVERLAY_LOCKED, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 164, 82, 164, 82);
        }
    }

    public void updateCamera(int id, Component name, boolean lastCamera) {
        if (lastCamera) {
            this.refreshButtons = true;
        }
        if (Objects.equals(name, Component.m_237119_())) {
            return;
        }
        this.BUTTONS.keySet().stream().filter(button -> this.BUTTONS.get(button) == id).findFirst().ifPresent(button -> button.m_93666_(name));
    }

    public void removeButton(int id) {
        this.BUTTONS.entrySet().stream().filter(entry -> (Integer)entry.getValue() == id).findFirst().ifPresent(entry -> {
            this.BUTTONS.keySet().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
            this.BUTTONS.remove(entry.getKey());
            this.renderButtons();
        });
    }

    public void flipCamera() {
        if (this.cameras >= 0 && !this.cameraFlipped) {
            SPMessages.sendToServer(new SelectCameraPacket(0, this.hand));
        }
        this.cameraFlipped = true;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        SPMessages.sendToServer(new UpdateCameraPacket(0.0f, 0.0f, 0.0f, true));
        Window window = Minecraft.m_91087_().m_91268_();
        Minecraft.m_91087_().f_91066_.m_231928_().m_231514_((Object)this.guiScale);
        window.m_85378_((double)window.m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), Minecraft.m_91087_().m_91390_()));
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        boolean dismount;
        if (Minecraft.m_91087_().f_91066_.f_92089_.getKey().m_84873_() == pKeyCode) {
            if (!this.moduleButtons.isEmpty()) {
                this.moduleButtons.entrySet().iterator().next().getValue().m_5691_();
            }
            return false;
        }
        if (ClientData.currentCamera == null) {
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        float yRot = 0.0f;
        float xRot = 0.0f;
        float zoom = 0.0f;
        boolean bl = dismount = pKeyCode == Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84873_();
        if (pKeyCode == 82 && this.rotateCooldown <= 0) {
            this.rotateCooldown = 5;
            this.rotateMap(1);
            SPMessages.sendToServer(new SyncMapRotation());
        }
        if (pKeyCode == Keybindings.LOCK.getKey().m_84873_()) {
            SPMessages.sendToServer(new LockCameraPacket());
        }
        if (pKeyCode == Minecraft.m_91087_().f_91066_.f_92086_.getKey().m_84873_()) {
            yRot = 1.0f;
        }
        if (pKeyCode == Minecraft.m_91087_().f_91066_.f_92088_.getKey().m_84873_()) {
            yRot = -1.0f;
        }
        if (pKeyCode == Minecraft.m_91087_().f_91066_.f_92085_.getKey().m_84873_()) {
            xRot = 1.0f;
        }
        if (pKeyCode == Minecraft.m_91087_().f_91066_.f_92087_.getKey().m_84873_()) {
            xRot = -1.0f;
        }
        if (pKeyCode == Keybindings.ZOOM_IN.getKey().m_84873_()) {
            zoom = 1.0f;
        }
        if (pKeyCode == Keybindings.ZOOM_OUT.getKey().m_84873_()) {
            zoom = -1.0f;
        }
        if (ClientData.currentCamera.moveable && ClientData.currentCameraEntity != null && ClientData.controller && !ClientData.currentCamera.panning) {
            ClientData.accumulatedYRot = Mth.m_14036_((float)(ClientData.accumulatedYRot - yRot), (float)-90.0f, (float)90.0f);
            ClientData.currentCameraEntity.f_20885_ = ClientData.yRot = Mth.m_14036_((float)(ClientData.baseYRot + ClientData.accumulatedYRot), (float)(ClientData.baseYRot - 90.0f), (float)(ClientData.baseYRot + 90.0f));
            ClientData.xRot = ClientData.accumulatedXRot = Mth.m_14036_((float)(ClientData.accumulatedXRot - xRot), (float)0.0f, (float)65.0f);
            ClientData.currentCameraEntity.m_146926_(ClientData.accumulatedXRot);
        }
        SPMessages.sendToServer(new UpdateCameraPacket(yRot, xRot, zoom, dismount));
        if (dismount) {
            this.m_7379_();
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private int getYOffset() {
        return this.minimized ? 13 : 20;
    }

    private boolean staticScreen() {
        return this.cameras <= 0 || this.staticTicks > 0 || ClientData.currentCamera == null || ClientData.currentCamera.hidden;
    }

    private void minimize() {
        this.minimized = !this.minimized;
        this.minimizeButton = Pair.of((Object)(this.f_96543_ - 44), (Object)(this.minimized ? this.f_96544_ - 21 : this.f_96544_ - 125));
        this.renderButtons();
    }

    protected void renderButtons() {
        this.BUTTONS.keySet().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        if (!this.minimized) {
            this.BUTTONS.keySet().stream().sorted(Comparator.comparing(this.BUTTONS::get)).skip(this.scrollIndex).sorted(Comparator.comparing(this.BUTTONS::get)).limit(5L).forEach(x$0 -> {
                SelectionButton cfr_ignored_0 = (SelectionButton)this.m_142416_((GuiEventListener)x$0);
            });
        }
    }

    public boolean canScroll(int delta) {
        return this.BUTTONS.size() > 5 && (delta > 0 ? this.scrollIndex > 0 : delta < 0 && this.scrollIndex < this.BUTTONS.size() - 5);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if ((double)((Integer)this.minimizeButton.getFirst() - 4) <= pMouseX && (double)((Integer)this.minimizeButton.getFirst() + 4) >= pMouseX && (double)((Integer)this.minimizeButton.getSecond() - 2) <= pMouseY && (double)((Integer)this.minimizeButton.getSecond() + 2) >= pMouseY) {
            this.minimize();
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int deltaInt = (int)pDelta;
        if (this.canScroll(deltaInt)) {
            this.scrollIndex = deltaInt > 0 ? Math.max(0, this.scrollIndex - 5) : (deltaInt < 0 ? Math.min(this.BUTTONS.size(), this.scrollIndex + 5) : this.scrollIndex);
            this.renderButtons();
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public static String convertGameTimeToAMPM(long gameTime) {
        int hours = (int)((gameTime / 1000L + 6L) % 24L);
        String ampm = hours >= 12 ? "PM" : "AM";
        hours = (hours %= 12) == 0 ? 12 : hours;
        return "%02d %s".formatted(hours, ampm);
    }
}

