/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zeus.sp.datagen.DatapackProvider;
import net.zeus.sp.datagen.ModBlockStateProvider;
import net.zeus.sp.datagen.ModItemModelProvider;
import net.zeus.sp.datagen.ModLanguageProvider;
import net.zeus.sp.datagen.ModLootTableProvider;
import net.zeus.sp.datagen.ModRecipeProvider;
import net.zeus.sp.datagen.ParticleProvider;
import net.zeus.sp.datagen.SoundProvider;

@Mod.EventBusSubscriber(modid="sp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(true, (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(true, (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ParticleProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new SoundProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ModLanguageProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackProvider(packOutput, lookupProvider));
    }
}

