/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.zeus.sp.level.block.blocks.MonitorBlock;
import net.zeus.sp.level.item.SPItems;
import software.bernie.geckolib.animatable.GeoItem;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "sp", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryObject registry : SPItems.ITEMS.getEntries()) {
            BlockItem blockItem;
            Object object;
            if (registry.get() instanceof ForgeSpawnEggItem) {
                this.spawnEgg((RegistryObject<? extends Item>)registry);
                continue;
            }
            if (registry.get() instanceof GeoItem || (object = registry.get()) instanceof BlockItem && (blockItem = (BlockItem)object).m_40614_() instanceof MonitorBlock) continue;
            try {
                this.simpleItem((RegistryObject<? extends Item>)registry);
            }
            catch (Exception e) {
                this.makePlaceholderModel((RegistryObject<? extends Item>)registry);
            }
        }
    }

    private ItemModelBuilder simpleItem(RegistryObject<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("sp", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder blockItem(RegistryObject<Block> block) {
        return (ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("sp", "block/" + block.getId().m_135815_()));
    }

    private ItemModelBuilder makePlaceholderModel(RegistryObject<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("minecraft", "item/book"));
    }

    private ItemModelBuilder handHeldItem(RegistryObject<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("sp", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder blockItemWithTexture(RegistryObject<Block> block, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", texture);
    }

    private ItemModelBuilder spawnEgg(RegistryObject<? extends Item> item) {
        return (ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/template_spawn_egg"));
    }
}

