/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zeus.sp.client.ClientData;
import net.zeus.sp.level.block.SPBlocks;
import net.zeus.sp.level.item.items.MapperItem;
import net.zeus.sp.networking.C2S.PosePacket;
import net.zeus.sp.networking.SPMessages;
import net.zeus.sp.util.Keybindings;
import software.bernie.geckolib.event.GeoRenderEvent;

@Mod.EventBusSubscriber(modid="sp", value={Dist.CLIENT})
public class ClientHandler {
    public static int crawling = 2;
    public static int crawlingCooldown = 0;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (crawlingCooldown > 0) {
            --crawlingCooldown;
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent event) {
        if (Keybindings.CRAWLING.m_90859_() && crawlingCooldown <= 0) {
            crawlingCooldown = 10;
            crawling = (crawling + 1) % PosePacket.poses.length;
            SPMessages.sendToServer(new PosePacket(crawling));
            ClientData.getPlayer().setForcedPose(null);
            if (crawling < 2) {
                ClientData.getPlayer().setForcedPose(PosePacket.poses[crawling]);
            }
            ClientData.getPlayer().m_20124_(PosePacket.poses[crawling]);
        }
    }

    @SubscribeEvent
    public static void renderOverlayEvent(RenderGuiOverlayEvent.Pre event) {
        if (ClientData.currentCamera == null || !event.isCancelable()) {
            return;
        }
        if (event.getOverlay() == VanillaGuiOverlay.EXPERIENCE_BAR.type()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderFOV(ViewportEvent.ComputeFov event) {
        if (ClientData.currentCamera == null) {
            return;
        }
        event.setFOV((double)(90.0f - ClientData.currentCamera.zoom));
    }

    @SubscribeEvent
    public static void renderBlockEvent(GeoRenderEvent.Block event) {
        if (ClientData.currentCamera == null) {
            return;
        }
        if (event.getBlockEntity().equals((Object)ClientData.currentCamera)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        Player player;
        ItemStack stack;
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_ENTITIES) && (stack = (player = ClientData.getPlayer()).m_21205_()).m_41720_() instanceof MapperItem) {
            AABB bounds = MapperItem.getBounds(stack);
            if (bounds == null) {
                return;
            }
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 vec = camera.m_90583_();
            AABB offsetBounds = new AABB(bounds.f_82288_ - vec.f_82479_ - (double)0.51f, bounds.f_82289_ - vec.f_82480_ - (double)0.51f, bounds.f_82290_ - vec.f_82481_ - (double)0.51f, bounds.f_82291_ - vec.f_82479_ + (double)0.51f, bounds.f_82292_ - vec.f_82480_ + (double)0.51f, bounds.f_82293_ - vec.f_82481_ + (double)0.51f);
            PoseStack pose = event.getPoseStack();
            VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)consumer, (AABB)offsetBounds, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Pair<BlockState, BlockPos>[][] blocks = MapperItem.getBlocks(bounds, player.m_21205_(), player.m_9236_());
            if (blocks == null) {
                return;
            }
            Pair<BlockState, BlockPos>[][] pairArray = blocks;
            int n = pairArray.length;
            for (int i = 0; i < n; ++i) {
                Pair<BlockState, BlockPos>[] block;
                for (Pair<BlockState, BlockPos> pair : block = pairArray[i]) {
                    if (pair == null) continue;
                    BlockPos pos = (BlockPos)pair.getSecond();
                    BlockState state = (BlockState)pair.getFirst();
                    AABB blockBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
                    boolean shouldRenderCull = event.getFrustum().m_113029_(blockBox);
                    if (state.m_60795_() || !shouldRenderCull) continue;
                    boolean isCam = state.m_60713_((Block)SPBlocks.CAMERA.get());
                    blockBox = blockBox.m_82386_(-vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
                    LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)consumer, (AABB)blockBox, (float)(isCam ? 0.0f : 1.0f), (float)(isCam ? 1.0f : 0.0f), (float)0.0f, (float)1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLeave(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientData.clear();
    }
}

