/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.level.block.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.zeus.sp.level.block.base.BaseHorizontalEntityBlock;
import net.zeus.sp.level.block.entities.CameraBlockEntity;
import org.jetbrains.annotations.Nullable;

public class CameraBlock
extends BaseHorizontalEntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public CameraBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CameraBlockEntity(pPos, pState);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        ItemStack itemStack = player.m_21120_(pHand);
        if (blockEntity instanceof CameraBlockEntity) {
            CameraBlockEntity cameraBlockEntity = (CameraBlockEntity)blockEntity;
            if (itemStack.m_150930_(Items.f_42656_) && itemStack.m_41788_()) {
                cameraBlockEntity.customName = itemStack.m_41786_();
                cameraBlockEntity.m_6596_();
                return super.m_6227_(pState, pLevel, pPos, player, pHand, pHit);
            }
        }
        if (blockEntity instanceof CameraBlockEntity) {
            CameraBlockEntity cameraBlockEntity = (CameraBlockEntity)blockEntity;
            if (CameraBlockEntity.isWrench(itemStack.m_41720_())) {
                if (!pHand.equals((Object)InteractionHand.MAIN_HAND)) return super.m_6227_(pState, pLevel, pPos, player, pHand, pHit);
                cameraBlockEntity.moveable = !cameraBlockEntity.moveable;
                player.m_5661_((Component)Component.m_237113_((String)(cameraBlockEntity.moveable ? "Camera is now moveable" : "Camera is now not moveable")), true);
                return super.m_6227_(pState, pLevel, pPos, player, pHand, pHit);
            }
        }
        if (!(blockEntity instanceof CameraBlockEntity)) return super.m_6227_(pState, pLevel, pPos, player, pHand, pHit);
        CameraBlockEntity cameraBlockEntity = (CameraBlockEntity)blockEntity;
        if (!pHand.equals((Object)InteractionHand.MAIN_HAND)) return super.m_6227_(pState, pLevel, pPos, player, pHand, pHit);
        if (pLevel.f_46443_) return super.m_6227_(pState, pLevel, pPos, player, pHand, pHit);
        cameraBlockEntity.loadModule(pLevel, itemStack);
        return super.m_6227_(pState, pLevel, pPos, player, pHand, pHit);
    }

    public int m_6376_(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        return this.shouldEmittRedstoneSignal(pLevel, pPos) ? 15 : 0;
    }

    public int m_6378_(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        return this.shouldEmittRedstoneSignal(pLevel, pPos) ? 15 : 0;
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pMovedByPiston) {
        CameraBlockEntity cameraBlockEntity;
        if (pNewState.m_60713_(state.m_60734_()) && (cameraBlockEntity = this.getCameraBlockEntity((BlockGetter)level, pos)) != null) {
            cameraBlockEntity.disconnect(cameraBlockEntity.getController());
            cameraBlockEntity.redstone = false;
        }
        super.m_6810_(state, level, pos, pNewState, pMovedByPiston);
        level.m_46672_(pos, (Block)this);
        Direction.m_235666_().forEach(direction -> level.m_46672_(pos.m_121945_(direction), (Block)this));
    }

    private boolean shouldEmittRedstoneSignal(BlockGetter pLevel, BlockPos pPos) {
        CameraBlockEntity cameraBlockEntity = this.getCameraBlockEntity(pLevel, pPos);
        return cameraBlockEntity != null && cameraBlockEntity.redstone && cameraBlockEntity.modules.contains((Object)CameraBlockEntity.Module.REDSTONE);
    }

    private CameraBlockEntity getCameraBlockEntity(BlockGetter pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CameraBlockEntity) {
            CameraBlockEntity cameraBlockEntity = (CameraBlockEntity)blockEntity;
            return cameraBlockEntity;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (pLevel1, pPos, pState1, pBlockEntity) -> {
            if (pBlockEntity instanceof CameraBlockEntity) {
                CameraBlockEntity cameraBlockEntity = (CameraBlockEntity)pBlockEntity;
                cameraBlockEntity.tick(pLevel);
            }
        };
    }
}

