/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.level.item.items;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.zeus.sp.level.block.SPBlocks;
import net.zeus.sp.level.item.SPItems;
import net.zeus.sp.level.item.items.Tablet;
import org.jetbrains.annotations.Nullable;

public class MapperItem
extends Item {
    public MapperItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pUsedHand) {
        ItemStack itemStack = player.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        if (offHand.m_41720_().equals(SPItems.TABLET.get()) && player.m_6047_()) {
            Tablet.loadMapData(offHand, null, null, List.of());
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        if (offHand.m_41720_().equals(SPItems.TABLET.get())) {
            AABB bounds = MapperItem.getBounds(itemStack);
            if (bounds == null) {
                player.m_5661_((Component)Component.m_237113_((String)"Please map the first and second points before uploading data"), true);
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            CompoundTag tag = itemStack.m_41784_();
            BlockPos fillPos = new BlockPos(tag.m_128451_("x-fill"), tag.m_128451_("y-fill"), tag.m_128451_("z-fill"));
            Tablet.loadMapData(offHand, bounds, fillPos, MapperItem.manualBlocks(itemStack));
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return super.m_7203_(pLevel, player, pUsedHand);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack itemStack;
        Player player = pContext.m_43723_();
        if (player != null && player.m_6047_()) {
            itemStack = player.m_21205_();
            CompoundTag tag = itemStack.m_41784_();
            tag.m_128405_("x-fill", pContext.m_8083_().m_123341_());
            tag.m_128405_("y-fill", pContext.m_8083_().m_123342_());
            tag.m_128405_("z-fill", pContext.m_8083_().m_123343_());
        }
        if (player == null || player.m_6047_()) {
            return InteractionResult.FAIL;
        }
        itemStack = player.m_21120_(pContext.m_43724_());
        MapperItem.map(player, itemStack, pContext.m_8083_(), MapperMode.SECOND_POINT);
        return super.m_6225_(pContext);
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pos, Player pPlayer) {
        if (pLevel.f_46443_) {
            return false;
        }
        ItemStack itemStack = pPlayer.m_21205_();
        if (pPlayer.m_6047_()) {
            CompoundTag tag = itemStack.m_41784_();
            if (tag.m_128441_("m-x")) {
                int x = tag.m_128451_("m-x");
                int y = tag.m_128451_("m-y");
                int z = tag.m_128451_("m-z");
                BlockPos pos2 = new BlockPos(x, y, z);
                ArrayList<BlockPos> manualBlocks = new ArrayList<BlockPos>();
                for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos2)) {
                    manualBlocks.add(blockPos.m_7949_());
                }
                MapperItem.addManual(manualBlocks, itemStack);
                tag.m_128473_("m-x");
                tag.m_128473_("m-y");
                tag.m_128473_("m-z");
            } else {
                tag.m_128405_("m-x", pos.m_123341_());
                tag.m_128405_("m-y", pos.m_123342_());
                tag.m_128405_("m-z", pos.m_123343_());
            }
            return false;
        }
        MapperItem.map(pPlayer, itemStack, pos, MapperMode.FIRST_POINT);
        return false;
    }

    public static int maxSize() {
        return 256;
    }

    public static void map(Player player, ItemStack stack, BlockPos pPos, MapperMode mode) {
        BlockPos otherPos;
        MapperMode other;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("x-%s".formatted(new Object[]{other = MapperMode.values()[(mode.ordinal() + 1) % MapperMode.values().length]})) && (otherPos = MapperItem.get(stack, other)) != null) {
            int zDiff = Math.abs(pPos.m_123343_() - otherPos.m_123343_());
            int xDiff = Math.abs(pPos.m_123341_() - otherPos.m_123341_());
            int max = MapperItem.maxSize();
            if (zDiff > max || xDiff > max) {
                player.m_5661_((Component)Component.m_237113_((String)"The maximum size for a map is %dx%d blocks | current %dx%d".formatted(max, max, xDiff, zDiff)), true);
                return;
            }
        }
        tag.m_128350_("x-%s".formatted(new Object[]{mode}), (float)pPos.m_123341_() + 0.5f);
        tag.m_128350_("y-%s".formatted(new Object[]{mode}), (float)pPos.m_123342_() + 0.5f);
        tag.m_128350_("z-%s".formatted(new Object[]{mode}), (float)pPos.m_123343_() + 0.5f);
        if (mode == MapperMode.FIRST_POINT) {
            tag.m_128405_("x-first", pPos.m_123341_());
            tag.m_128405_("y-first", pPos.m_123342_());
            tag.m_128405_("z-first", pPos.m_123343_());
            tag.m_128405_("x-fill", pPos.m_123341_());
            tag.m_128405_("y-fill", pPos.m_123342_());
            tag.m_128405_("z-fill", pPos.m_123343_());
        }
        player.m_5661_((Component)Component.m_237113_((String)"Mapped %s point at %s".formatted(mode.toString().replace("_", " ").toLowerCase(), pPos.m_123344_())), true);
    }

    public static void addManual(List<BlockPos> pos, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128437_("manual", 10);
        LinkedList<Tag> toRemove = new LinkedList<Tag>();
        for (Tag t : list) {
            CompoundTag posTag = (CompoundTag)t;
            BlockPos blockPos = new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z"));
            if (!pos.contains(blockPos)) continue;
            toRemove.add(t);
            pos.remove(blockPos);
        }
        for (Tag t : toRemove) {
            list.remove((Object)t);
        }
        MapperItem.toTag(pos, tag, list);
    }

    protected static void toTag(List<BlockPos> pos, CompoundTag tag, ListTag list) {
        for (BlockPos blockPos : pos) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", blockPos.m_123341_());
            posTag.m_128405_("y", blockPos.m_123342_());
            posTag.m_128405_("z", blockPos.m_123343_());
            list.add((Object)posTag);
        }
        tag.m_128365_("manual", (Tag)list);
    }

    public static List<BlockPos> manualBlocks(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128437_("manual", 10);
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        for (Tag t : list) {
            CompoundTag posTag = (CompoundTag)t;
            blocks.add(new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z")));
        }
        return blocks;
    }

    public static AABB getBounds(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("x-%s".formatted(new Object[]{MapperMode.FIRST_POINT})) || !tag.m_128441_("x-%s".formatted(new Object[]{MapperMode.SECOND_POINT}))) {
            return null;
        }
        float x1 = tag.m_128457_("x-%s".formatted(new Object[]{MapperMode.FIRST_POINT}));
        float y1 = tag.m_128457_("y-%s".formatted(new Object[]{MapperMode.FIRST_POINT}));
        float z1 = tag.m_128457_("z-%s".formatted(new Object[]{MapperMode.FIRST_POINT}));
        float x2 = tag.m_128457_("x-%s".formatted(new Object[]{MapperMode.SECOND_POINT}));
        float y2 = tag.m_128457_("y-%s".formatted(new Object[]{MapperMode.SECOND_POINT}));
        float z2 = tag.m_128457_("z-%s".formatted(new Object[]{MapperMode.SECOND_POINT}));
        return new AABB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static BlockPos get(ItemStack stack, MapperMode mode) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("x-%s".formatted(new Object[]{mode}))) {
            return null;
        }
        float x = tag.m_128457_("x-%s".formatted(new Object[]{mode}));
        float y = tag.m_128457_("y-%s".formatted(new Object[]{mode}));
        float z = tag.m_128457_("z-%s".formatted(new Object[]{mode}));
        return BlockPos.m_274561_((double)x, (double)y, (double)z);
    }

    public static Pair<BlockState, BlockPos>[][] getBlocks(AABB bounds, ItemStack stack, Level level) {
        int zStart;
        int yStart;
        int x1 = (int)Math.floor(bounds.f_82288_);
        int z1 = (int)Math.floor(bounds.f_82290_);
        int x2 = (int)Math.floor(bounds.f_82291_);
        int z2 = (int)Math.floor(bounds.f_82293_);
        int yMin = (int)bounds.f_82289_ - 1;
        int yMax = (int)bounds.f_82292_ + 1;
        yMin = Math.min(yMin, yMax);
        Pair[][] blocks = new Pair[x2 - x1 + 1][z2 - z1 + 1];
        CompoundTag tag = stack.m_41784_();
        int xStart = tag.m_128451_("x-fill");
        BlockPos floodFillStart = new BlockPos(xStart, yStart = tag.m_128451_("y-fill"), zStart = tag.m_128451_("z-fill"));
        BlockState startState = level.m_8055_(floodFillStart);
        if (startState.m_60795_()) {
            return null;
        }
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(floodFillStart);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            int x = pos.m_123341_();
            int z = pos.m_123343_();
            BlockState state = level.m_8055_(pos);
            if (x < x1 || x > x2 || z < z1 || z > z2 || state.m_60795_() || !state.m_60838_((BlockGetter)level, pos) || blocks[x - x1][z - z1] != null) continue;
            blocks[x - x1][z - z1] = Pair.of((Object)level.m_8055_(pos), (Object)pos);
            queue.add(pos.m_122012_());
            queue.add(pos.m_122019_());
            queue.add(pos.m_122029_());
            queue.add(pos.m_122024_());
        }
        List<BlockPos> manualBlocks = MapperItem.manualBlocks(stack);
        for (int i = 0; i < blocks.length; ++i) {
            for (int y = 0; y < yMax - yMin; ++y) {
                for (int j = 0; j < blocks[i].length; ++j) {
                    BlockPos pos = new BlockPos(i + x1, y + yMin, j + z1);
                    BlockState state = level.m_8055_(pos);
                    boolean contains = manualBlocks.contains(pos);
                    if (blocks[i][j] == null) {
                        blocks[i][j] = Pair.of((Object)Blocks.f_50016_.m_49966_(), (Object)new BlockPos(i + x1, yMin, j + z1));
                    } else if (((BlockState)blocks[i][j].getFirst()).m_60734_().equals(SPBlocks.CAMERA.get())) continue;
                    if (!((BlockState)blocks[i][j].getFirst()).m_60795_() && contains) {
                        blocks[i][j] = Pair.of((Object)Blocks.f_50016_.m_49966_(), (Object)pos);
                    } else if (contains) {
                        blocks[i][j] = Pair.of((Object)state, (Object)pos);
                    }
                    if (!state.m_60713_((Block)SPBlocks.CAMERA.get())) continue;
                    blocks[i][j] = Pair.of((Object)state, (Object)pos);
                }
            }
        }
        return blocks;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237113_((String)"Left click to map first point").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Right click to map second point").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Shift + Right click to set fill position").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Shift + Left click to add manual blocks (2 pos)").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Right click with tablet in off-hand to upload data").m_130940_(ChatFormatting.GRAY));
    }

    public static enum MapperMode {
        FIRST_POINT,
        SECOND_POINT;

    }
}

