/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.level.item.items;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.zeus.sp.data.PlayerData;
import net.zeus.sp.level.block.entities.CameraBlockEntity;
import net.zeus.sp.level.client.renderer.item.TabletRenderer;
import net.zeus.sp.level.item.items.MapperItem;
import net.zeus.sp.level.sounds.SPSounds;
import net.zeus.sp.networking.S2C.OpenTabletPacket;
import net.zeus.sp.networking.SPMessages;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Tablet
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation FLIP_UP = RawAnimation.begin().thenPlay("flip_up");
    private static final RawAnimation FLIP_DOWN = RawAnimation.begin().thenPlay("flip_down");

    public Tablet(Item.Properties pProperties) {
        super(pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pUsedHand) {
        if (pUsedHand.equals((Object)InteractionHand.OFF_HAND)) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(pUsedHand));
        }
        ItemStack stack = player.m_21120_(pUsedHand);
        Tablet.getCameras(pLevel, stack);
        if (!pLevel.f_46443_) {
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)pLevel)), "controller", "flip_up");
        }
        Tablet.openCams(player, stack);
        return super.m_7203_(pLevel, player, pUsedHand);
    }

    private static void openCams(Player player, ItemStack stack) {
        PlayerData.get((Player)player).tabletItem = stack;
        player.m_9236_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SPSounds.TABLET_USE.get(), SoundSource.PLAYERS, 1.0f, 0.9f);
        player.m_6986_(stack, InteractionHand.MAIN_HAND);
    }

    public static void tryOpenCams(Player player, ItemStack stack) {
        if (!player.m_9236_().f_46443_) {
            SPMessages.sendToPlayer(new OpenTabletPacket(stack), player);
            return;
        }
        Tablet.openCams(player, stack);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        ItemStack stack = pContext.m_43722_();
        BlockEntity entity = pContext.m_43725_().m_7702_(pContext.m_8083_());
        if (entity instanceof CameraBlockEntity) {
            CameraBlockEntity cameraBlockEntity = (CameraBlockEntity)entity;
            if (player != null) {
                this.addCamera(cameraBlockEntity, player, stack);
                return InteractionResult.FAIL;
            }
        }
        return super.m_6225_(pContext);
    }

    private void addCamera(CameraBlockEntity blockEntity, Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128437_("cameras", 10);
        for (Tag t : list) {
            CompoundTag cameraTag = (CompoundTag)t;
            if (!cameraTag.m_128461_("location").equals(blockEntity.m_58899_().m_123344_())) continue;
            return;
        }
        player.m_5661_((Component)Component.m_237113_((String)"Camera Connected"), true);
        CompoundTag cameraTag = new CompoundTag();
        cameraTag.m_128405_("id", list.size());
        cameraTag.m_128405_("x", blockEntity.m_58899_().m_123341_());
        cameraTag.m_128405_("y", blockEntity.m_58899_().m_123342_());
        cameraTag.m_128405_("z", blockEntity.m_58899_().m_123343_());
        cameraTag.m_128359_("location", blockEntity.m_58899_().m_123344_());
        list.add((Object)cameraTag);
        tag.m_128365_("cameras", (Tag)list);
    }

    public static List<CameraBlockEntity> getCameras(Level level, ItemStack stack) {
        HashMap<CameraBlockEntity, Integer> camerasMap = new HashMap<CameraBlockEntity, Integer>();
        ListTag list = stack.m_41784_().m_128437_("cameras", 10);
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            CompoundTag cameraTag = (CompoundTag)iterator.next();
            BlockEntity entity = level.m_7702_(new BlockPos(cameraTag.m_128451_("x"), cameraTag.m_128451_("y"), cameraTag.m_128451_("z")));
            if (entity instanceof CameraBlockEntity) {
                CameraBlockEntity cameraBlockEntity = (CameraBlockEntity)entity;
                camerasMap.put(cameraBlockEntity, cameraTag.m_128451_("id"));
                continue;
            }
            if (level.f_46443_) continue;
            iterator.remove();
        }
        ArrayList<CameraBlockEntity> cameras = new ArrayList<CameraBlockEntity>(camerasMap.keySet());
        cameras.sort(Comparator.comparingInt(camerasMap::get));
        return cameras;
    }

    public static Optional<List<CameraBlockEntity>> getCamerasSafe(Level level, ItemStack stack) {
        List<CameraBlockEntity> cameras = Tablet.getCameras(level, stack);
        return level == null || stack.m_41619_() ? Optional.empty() : (cameras.isEmpty() ? Optional.empty() : Optional.of(cameras));
    }

    public static int cameraCount(ItemStack stack) {
        return stack.m_41784_().m_128437_("cameras", 10).size();
    }

    public static Optional<CameraBlockEntity> getCurrentCamera(Player player) {
        return player == null || PlayerData.get((Player)player).currentCamera == null ? Optional.empty() : Optional.ofNullable(PlayerData.get((Player)player).currentCamera);
    }

    public static void loadMapData(ItemStack stack, @Nullable AABB aabb, BlockPos fill, List<BlockPos> pos) {
        CompoundTag tag = stack.m_41784_();
        if (aabb == null) {
            tag.m_128473_("x1");
            tag.m_128473_("y1");
            tag.m_128473_("z1");
            tag.m_128473_("x2");
            tag.m_128473_("y2");
            tag.m_128473_("z2");
            tag.m_128473_("x-fill");
            tag.m_128473_("y-fill");
            tag.m_128473_("z-fill");
            tag.m_128473_("manual");
            return;
        }
        tag.m_128350_("x1", (float)aabb.f_82288_);
        tag.m_128350_("y1", (float)aabb.f_82289_);
        tag.m_128350_("z1", (float)aabb.f_82290_);
        tag.m_128350_("x2", (float)aabb.f_82291_);
        tag.m_128350_("y2", (float)aabb.f_82292_);
        tag.m_128350_("z2", (float)aabb.f_82293_);
        tag.m_128405_("x-fill", fill.m_123341_());
        tag.m_128405_("y-fill", fill.m_123342_());
        tag.m_128405_("z-fill", fill.m_123343_());
        ListTag list = new ListTag();
        MapperItem.toTag(pos, tag, list);
    }

    public static AABB getMapData(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("x1")) {
            return null;
        }
        float x1 = tag.m_128457_("x1");
        float y1 = tag.m_128457_("y1");
        float z1 = tag.m_128457_("z1");
        float x2 = tag.m_128457_("x2");
        float y2 = tag.m_128457_("y2");
        float z2 = tag.m_128457_("z2");
        return new AABB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.STOP).triggerableAnim("flip_up", FLIP_UP).triggerableAnim("flip_down", FLIP_DOWN)});
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private TabletRenderer tabletRenderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.tabletRenderer == null) {
                    this.tabletRenderer = new TabletRenderer();
                }
                return this.tabletRenderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

