/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.networking.C2S;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.zeus.sp.data.PlayerData;
import net.zeus.sp.level.block.entities.CameraBlockEntity;
import net.zeus.sp.level.item.SPItems;
import net.zeus.sp.level.item.items.Tablet;
import net.zeus.sp.networking.Packet;
import net.zeus.sp.networking.S2C.SendCameraInfoPacket;
import net.zeus.sp.networking.SPMessages;

public class RequestCameraInfoPacket
extends Packet {
    private final int cameraID;
    private final InteractionHand hand;
    private final boolean last;

    public RequestCameraInfoPacket(InteractionHand hand, int cameraID, boolean last) {
        this.hand = hand;
        this.cameraID = cameraID;
        this.last = last;
    }

    public RequestCameraInfoPacket(FriendlyByteBuf byteBuf) {
        this.hand = (InteractionHand)byteBuf.m_130066_(InteractionHand.class);
        this.cameraID = byteBuf.readInt();
        this.last = byteBuf.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.m_130068_((Enum)this.hand);
        byteBuf.writeInt(this.cameraID);
        byteBuf.writeBoolean(this.last);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (context.getSender() == null) {
            return;
        }
        ItemStack stack = !context.getSender().m_21120_(this.hand).m_150930_((Item)SPItems.TABLET.get()) ? PlayerData.get((Player)context.getSender()).tabletItem : context.getSender().m_21120_(this.hand);
        context.enqueueWork(() -> Tablet.getCamerasSafe(context.getSender().m_9236_(), stack).ifPresent(cameras -> ((CameraBlockEntity)((Object)((Object)((Object)cameras.get(this.cameraID))))).sendCameraInfo(context.getSender(), stack, this.cameraID)));
        if (this.last) {
            SPMessages.sendToPlayer(new SendCameraInfoPacket(-1, BlockPos.f_121853_, (Component)Component.m_237119_(), true, 0.0f), (Player)context.getSender());
        }
        context.setPacketHandled(true);
    }
}

