/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.networking.S2C;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;
import net.zeus.sp.client.ClientData;
import net.zeus.sp.networking.Packet;

public class SendCameraInfoPacket
extends Packet {
    private final int cameraID;
    private final BlockPos pos;
    private final Component customName;
    private final boolean lastCamera;
    private final float yRot;

    public SendCameraInfoPacket(int cameraID, BlockPos pos, Component customName, boolean lastCamera, float yRot) {
        this.cameraID = cameraID;
        this.pos = pos;
        this.customName = customName;
        this.lastCamera = lastCamera;
        this.yRot = yRot;
    }

    public SendCameraInfoPacket(FriendlyByteBuf byteBuf) {
        this.cameraID = byteBuf.readInt();
        this.pos = byteBuf.m_130135_();
        this.customName = byteBuf.m_130238_();
        this.lastCamera = byteBuf.readBoolean();
        this.yRot = byteBuf.readFloat();
    }

    @Override
    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.cameraID);
        byteBuf.m_130064_(this.pos);
        byteBuf.m_130083_(this.customName);
        byteBuf.writeBoolean(this.lastCamera);
        byteBuf.writeFloat(this.yRot);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> ClientData.handleCameraInfo(this.cameraID, this.pos, this.customName, this.lastCamera, this.yRot));
        context.setPacketHandled(true);
    }
}

