/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.networking;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.zeus.sp.networking.C2S.EditCameraPacket;
import net.zeus.sp.networking.C2S.HandleModulePacket;
import net.zeus.sp.networking.C2S.LockCameraPacket;
import net.zeus.sp.networking.C2S.PosePacket;
import net.zeus.sp.networking.C2S.RequestCameraInfoPacket;
import net.zeus.sp.networking.C2S.SelectCameraPacket;
import net.zeus.sp.networking.C2S.SyncMapRotation;
import net.zeus.sp.networking.C2S.UpdateCameraPacket;
import net.zeus.sp.networking.Packet;
import net.zeus.sp.networking.S2C.CloseScreenPacket;
import net.zeus.sp.networking.S2C.OpenTabletPacket;
import net.zeus.sp.networking.S2C.SendCameraInfoPacket;
import net.zeus.sp.networking.S2C.SetCameraPacket;

public class SPMessages {
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("sp", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
    private static int packetId = 0;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SPMessages.registerPacket(SetCameraPacket.class, NetworkDirection.PLAY_TO_CLIENT);
        SPMessages.registerPacket(UpdateCameraPacket.class, NetworkDirection.PLAY_TO_SERVER);
        SPMessages.registerPacket(SelectCameraPacket.class, NetworkDirection.PLAY_TO_SERVER);
        SPMessages.registerPacket(LockCameraPacket.class, NetworkDirection.PLAY_TO_SERVER);
        SPMessages.registerPacket(PosePacket.class, NetworkDirection.PLAY_TO_SERVER);
        SPMessages.registerPacket(RequestCameraInfoPacket.class, NetworkDirection.PLAY_TO_SERVER);
        SPMessages.registerPacket(SendCameraInfoPacket.class, NetworkDirection.PLAY_TO_CLIENT);
        SPMessages.registerPacket(SyncMapRotation.class, NetworkDirection.PLAY_TO_SERVER);
        SPMessages.registerPacket(HandleModulePacket.class, NetworkDirection.PLAY_TO_SERVER);
        SPMessages.registerPacket(EditCameraPacket.class, NetworkDirection.PLAY_TO_SERVER);
        SPMessages.registerPacket(OpenTabletPacket.class, NetworkDirection.PLAY_TO_CLIENT);
        SPMessages.registerPacket(CloseScreenPacket.class, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), message);
        }
    }

    private static <P extends Packet> void registerPacket(Class<P> msgClass, NetworkDirection direction) {
        INSTANCE.messageBuilder(msgClass, SPMessages.id(), direction).decoder(byteBuf -> {
            try {
                return (Packet)msgClass.getConstructor(FriendlyByteBuf.class).newInstance(byteBuf);
            }
            catch (Exception var3) {
                throw new RuntimeException(var3);
            }
        }).encoder(Packet::toBytes).consumerMainThread((msg, supplier) -> msg.handle((NetworkEvent.Context)supplier.get())).add();
    }
}

