#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D DiffuseDepthSampler;

uniform mat4 ProjMat;
uniform vec2 OutSize;
uniform vec2 ScreenSize;
uniform float Fov;

in vec2 texCoord;

out vec4 fragColor;

float near = 0.06;
float far  = 1000.0;
float LinearizeDepth(float depth)
{
    float z = depth * 2.0 - 1.0;
    return (near * far) / (far + near - z * (far - near));
}

const float exposure = 40.0;
const float AOE = 16.0;
void main(){
    float depth = LinearizeDepth(texture(DiffuseDepthSampler, texCoord).r);
    float distance = length(vec3(1.0, (2.0 * texCoord - 1.0) * vec2(ScreenSize.x / ScreenSize.y, 1.0) * tan(radians(Fov / 2.0))) * depth);

    vec2 uv = texCoord;
    float d = sqrt(pow((uv.x - 0.5), 2.0) + pow((uv.y - 0.5), 2.0));
    d = exp(-(d * AOE)) * exposure / (distance * 0.15);
    fragColor = vec4(texture(DiffuseSampler, texCoord).rgb * clamp(1.0 + d, 0.1, 10.0), 1.0);
}