/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.mint_gaming_studios.fishing_plus.client.gui.FishBookMenu;
import net.mint_gaming_studios.fishing_plus.fish.FishStats;
import org.apache.commons.lang3.StringUtils;

public class FishBookScreen
extends AbstractContainerScreen<FishBookMenu> {
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("minecraft", "textures/gui/book.png");
    private int currentPage = 0;
    private Button nextPageButton;
    private Button previousPageButton;

    public FishBookScreen(FishBookMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 192;
        this.f_97727_ = 192;
        this.f_97728_ = -9999;
        this.f_97730_ = -9999;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.nextPageButton = (Button)this.m_142416_((GuiEventListener)new PageButton(x + 116, y + 159, true, b -> this.pageForward()));
        this.previousPageButton = (Button)this.m_142416_((GuiEventListener)new PageButton(x + 43, y + 159, false, b -> this.pageBack()));
        this.updateButtonVisibility();
    }

    private void pageForward() {
        if (this.currentPage < this.getPageCount() - 1) {
            ++this.currentPage;
            this.updateButtonVisibility();
        }
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updateButtonVisibility();
        }
    }

    private int getPageCount() {
        return ((FishBookMenu)this.f_97732_).fishPages.size();
    }

    private void updateButtonVisibility() {
        this.nextPageButton.f_93624_ = this.currentPage < this.getPageCount() - 1;
        this.previousPageButton.f_93624_ = this.currentPage > 0;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        float slotY;
        float scale;
        float itemSize;
        float slotX;
        super.m_280072_(pGuiGraphics, pX, pY);
        if (this.currentPage >= this.getPageCount()) {
            return;
        }
        Item fishItem = ((FishBookMenu)this.f_97732_).fishPages.get(this.currentPage);
        FishStats stats = ((FishBookMenu)this.f_97732_).fishData.get(fishItem);
        if (stats != null && !stats.largestFishStack().m_41619_() && this.m_6774_((int)(slotX = (float)(this.f_97735_ + 36) + (116.0f - (itemSize = 16.0f * (scale = 5.0f))) / 2.0f), (int)(slotY = (float)(this.f_97736_ + 35)), (int)itemSize, (int)itemSize, pX, pY)) {
            pGuiGraphics.m_280557_(this.f_96547_, stats.largestFishStack().m_41786_(), pX, pY);
        }
    }

    private Component getCleanFishName(Item fishItem) {
        String name = fishItem.m_41466_().getString();
        if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)"Raw ")) {
            return Component.m_237113_((String)name.substring(4));
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)"Roher ")) {
            return Component.m_237113_((String)name.substring(6));
        }
        return fishItem.m_41466_();
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_280273_(pGuiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_97735_;
        int y = this.f_97736_;
        pGuiGraphics.m_280218_(BOOK_TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (this.currentPage >= this.getPageCount()) {
            return;
        }
        Item fishItem = ((FishBookMenu)this.f_97732_).fishPages.get(this.currentPage);
        FishStats stats = ((FishBookMenu)this.f_97732_).fishData.get(fishItem);
        int contentX = this.f_97735_ + 36;
        int contentY = this.f_97736_ + 20;
        Component fishName = this.getCleanFishName(fishItem);
        int nameWidth = this.f_96547_.m_92852_((FormattedText)fishName);
        pGuiGraphics.m_280614_(this.f_96547_, fishName, contentX + (116 - nameWidth) / 2, contentY, 0, false);
        if (stats != null && !stats.largestFishStack().m_41619_()) {
            float scale = 5.0f;
            float itemSize = 16.0f * scale;
            float slotX = (float)contentX + (116.0f - itemSize) / 2.0f;
            float slotY = contentY + 15;
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(slotX, slotY, 100.0f);
            pGuiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            pGuiGraphics.m_280480_(stats.largestFishStack(), 0, 0);
            pGuiGraphics.m_280168_().m_85849_();
            int textBlockY = (int)(slotY + itemSize + 5.0f);
            float textScale = 0.8f;
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_((float)contentX, (float)textBlockY, 0.0f);
            pGuiGraphics.m_280168_().m_85841_(textScale, textScale, textScale);
            Objects.requireNonNull(this.f_96547_);
            int lineSpacing = (int)(9.0f / textScale + 2.0f);
            int currentLineY = 0;
            MutableComponent largestFishText = Component.m_237115_((String)"gui.fishing_plus.book.largest_fish").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)(stats.largestSize() + " cm")).m_130940_(ChatFormatting.BLACK));
            pGuiGraphics.m_280614_(this.f_96547_, (Component)largestFishText, 0, currentLineY, 0, false);
            MutableComponent heaviestFishText = Component.m_237115_((String)"gui.fishing_plus.book.heaviest_fish").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)this.getFormattedWeight(stats.heaviestWeight())).m_130940_(ChatFormatting.BLACK));
            pGuiGraphics.m_280614_(this.f_96547_, (Component)heaviestFishText, 0, currentLineY += lineSpacing, 0, false);
            MutableComponent totalCaughtText = Component.m_237115_((String)"gui.fishing_plus.book.total_caught").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(stats.totalCaught())).m_130940_(ChatFormatting.BLACK));
            pGuiGraphics.m_280614_(this.f_96547_, (Component)totalCaughtText, 0, currentLineY += lineSpacing, 0, false);
            pGuiGraphics.m_280168_().m_85849_();
        } else {
            MutableComponent notYet = Component.m_237115_((String)"gui.fishing_plus.book.not_yet_caught");
            int notYetWidth = this.f_96547_.m_92852_((FormattedText)notYet);
            pGuiGraphics.m_280614_(this.f_96547_, (Component)notYet, contentX + (116 - notYetWidth) / 2, contentY + 60, 0, false);
        }
    }

    private String getFormattedWeight(int weight) {
        if (weight >= 1000000) {
            return String.format("%.2f t", (double)weight / 1000000.0);
        }
        if (weight >= 1000) {
            return String.format("%.1f kg", (double)weight / 1000.0);
        }
        return String.format("%d g", weight);
    }

    static class PageButton
    extends Button {
        private final boolean isForward;

        public PageButton(int pX, int pY, boolean pIsForward, Button.OnPress pOnPress) {
            super(pX, pY, 23, 13, (Component)Component.m_237119_(), pOnPress, f_252438_);
            this.isForward = pIsForward;
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int u = 0;
            int v = 192;
            if (this.m_198029_()) {
                u += 23;
            }
            if (!this.isForward) {
                v += 13;
            }
            pGuiGraphics.m_280218_(BOOK_TEXTURE, this.m_252754_(), this.m_252907_(), u, v, 23, 13);
        }
    }
}

