/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.client.gui;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FishCaughtScreen
extends Screen {
    private final ItemStack fishStack;
    private final int fishSize;
    private final int fishWeight;
    private final int totalCaught;
    private final int recordSize;
    private final int recordWeight;

    public FishCaughtScreen(ItemStack fishStack, int fishSize, int fishWeight, int totalCaught, int recordSize, int recordWeight) {
        super((Component)Component.m_237115_((String)"gui.fishing_plus.fish_caught.title"));
        this.fishStack = fishStack;
        this.fishSize = fishSize;
        this.fishWeight = fishWeight;
        this.totalCaught = totalCaught;
        this.recordSize = recordSize;
        this.recordWeight = recordWeight;
    }

    public boolean m_6913_() {
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 32 || keyCode == 257) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    private Component getCleanFishName(Item fishItem) {
        return fishItem.m_41466_();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int contentX = (this.f_96543_ - 116) / 2;
        int contentY = (this.f_96544_ - 180) / 2;
        Component fishName = this.getCleanFishName(this.fishStack.m_41720_());
        int nameWidth = this.f_96547_.m_92852_((FormattedText)fishName);
        pGuiGraphics.m_280614_(this.f_96547_, fishName, contentX + (116 - nameWidth) / 2, contentY, 0xFFFFFF, false);
        float scale = 5.0f;
        float itemSize = 16.0f * scale;
        float slotX = (float)contentX + (116.0f - itemSize) / 2.0f;
        float slotY = contentY + 15;
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(slotX, slotY, 100.0f);
        pGuiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        pGuiGraphics.m_280480_(this.fishStack, 0, 0);
        pGuiGraphics.m_280168_().m_85849_();
        int textBlockY = (int)(slotY + itemSize + 5.0f);
        float textScale = 0.8f;
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)contentX, (float)textBlockY, 0.0f);
        pGuiGraphics.m_280168_().m_85841_(textScale, textScale, textScale);
        Objects.requireNonNull(this.f_96547_);
        int lineSpacing = (int)(9.0f / textScale + 2.0f);
        int currentLineY = 0;
        MutableComponent sizeLabel = Component.m_237115_((String)"gui.fishing_plus.caught.size");
        MutableComponent sizeText = sizeLabel.m_6881_().m_7220_((Component)Component.m_237113_((String)(" " + this.fishSize + "cm")));
        if (this.fishSize > this.recordSize) {
            sizeText = sizeText.m_6881_().m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"gui.fishing_plus.caught.new_record").m_130940_(ChatFormatting.GOLD));
        }
        pGuiGraphics.m_280614_(this.f_96547_, (Component)sizeText, 0, currentLineY, 0xFFFFFF, false);
        currentLineY += lineSpacing;
        MutableComponent weightLabel = Component.m_237115_((String)"gui.fishing_plus.caught.weight");
        Component weightValue = this.getFormattedWeight(this.fishWeight);
        MutableComponent weightText = weightLabel.m_6881_().m_7220_((Component)Component.m_237113_((String)" ")).m_7220_(weightValue);
        if (this.fishWeight > this.recordWeight) {
            weightText = weightText.m_6881_().m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"gui.fishing_plus.caught.new_record").m_130940_(ChatFormatting.GOLD));
        }
        pGuiGraphics.m_280614_(this.f_96547_, (Component)weightText, 0, currentLineY, 0xFFFFFF, false);
        MutableComponent totalCaughtLabel = Component.m_237115_((String)"gui.fishing_plus.book.total_caught");
        MutableComponent totalCaughtText = totalCaughtLabel.m_6881_().m_7220_((Component)Component.m_237113_((String)("" + (this.totalCaught + 1))));
        pGuiGraphics.m_280614_(this.f_96547_, (Component)totalCaughtText, 0, currentLineY += lineSpacing, 0xFFFFFF, false);
        pGuiGraphics.m_280168_().m_85849_();
        MutableComponent continueMsg = Component.m_237115_((String)"gui.fishing_plus.caught.continue");
        int msgWidth = this.f_96547_.m_92852_((FormattedText)continueMsg);
        pGuiGraphics.m_280614_(this.f_96547_, (Component)continueMsg, (this.f_96543_ - msgWidth) / 2, this.f_96544_ - 30, 0xFFFFFF, true);
    }

    private Component getFormattedWeight(int weight) {
        if (weight >= 1000000) {
            return Component.m_237110_((String)"gui.fishing_plus.caught.weight.tons", (Object[])new Object[]{String.format("%.2f", (double)weight / 1000000.0)});
        }
        if (weight >= 1000) {
            return Component.m_237110_((String)"gui.fishing_plus.caught.weight.kg", (Object[])new Object[]{String.format("%.1f", (double)weight / 1000.0)});
        }
        return Component.m_237110_((String)"gui.fishing_plus.caught.weight.grams", (Object[])new Object[]{weight});
    }
}

