/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.mint_gaming_studios.fishing_plus.client.gui.FishCaughtScreen;
import net.mint_gaming_studios.fishing_plus.fish.FishData;
import net.mint_gaming_studios.fishing_plus.network.ModMessages;
import net.mint_gaming_studios.fishing_plus.network.packet.FishingSuccessC2SPacket;
import org.slf4j.Logger;

public class FishingMinigameScreen
extends Screen {
    private static final ResourceLocation PROGRESS_BAR = new ResourceLocation("fishing_plus", "textures/gui/fishing/progress_bar.png");
    private static final ResourceLocation PROGRESS_BAR_FILL = new ResourceLocation("fishing_plus", "textures/gui/fishing/progress_bar_fill.png");
    private static final ResourceLocation RING = new ResourceLocation("fishing_plus", "textures/gui/fishing/ring.png");
    private static final ResourceLocation TARGET_ZONE_GOOD = new ResourceLocation("fishing_plus", "textures/gui/fishing/target_zone_good.png");
    private static final ResourceLocation TARGET_ZONE_PERFECT = new ResourceLocation("fishing_plus", "textures/gui/fishing/target_zone_perfect.png");
    private static final ResourceLocation CIRCLE = new ResourceLocation("fishing_plus", "textures/gui/fishing/circle.png");
    private static final ResourceLocation LOWER_COVER = new ResourceLocation("fishing_plus", "textures/gui/fishing/lower_cover.png");
    private static final ResourceLocation FISH_INDICATOR = new ResourceLocation("fishing_plus", "textures/gui/fishing/fish_indicator.png");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("fishing_plus", "textures/gui/fishing/minigame_background.png");
    private static final int SLOTS_BACKGROUND_WIDTH = 32;
    private static final int SLOTS_BACKGROUND_HEIGHT = 120;
    private static final int SLOTS_SPACING = 12;
    private ItemStack[] displayItems;
    private static final int PROGRESS_BAR_WIDTH = 32;
    private static final int PROGRESS_BAR_HEIGHT = 200;
    private static final int RING_SIZE = 256;
    private static final int CIRCLE_SIZE = 16;
    private static final int FISH_INDICATOR_WIDTH = 24;
    private static final int FISH_INDICATOR_HEIGHT = 12;
    private static final float LOSING_THRESHOLD = 5.0f;
    private static final float WINNING_THRESHOLD = 92.0f;
    private static final int MAX_ACTIVE_CIRCLES = 4;
    private static final long INITIAL_SPAWN_DELAY = 0L;
    private static final long NORMAL_SPAWN_DELAY = 500L;
    private static final long INITIAL_PHASE_DURATION = 5000L;
    private long lastCircleSpawnTime;
    private float fishPosition = 50.0f;
    private float lastUpdateTime = 0.0f;
    private final List<CircleElement> activeCircles = new ArrayList<CircleElement>();
    private static final int RING_Y_OFFSET = -15;
    private static final float PERFECT_ZONE_START = 260.0f;
    private static final float PERFECT_ZONE_END = 280.0f;
    private static final float GOOD_ZONE_START = 240.0f;
    private static final float GOOD_ZONE_END = 300.0f;
    private static final float BASE_CIRCLE_SPEED = 4.0f;
    private static final float SPEED_VARIATION = 0.8f;
    private int centerX;
    private int centerY;
    private static final int BASE_WIDTH = 1920;
    private static final int BASE_HEIGHT = 1080;
    private float scaleX;
    private float scaleY;
    private float uniformScale;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float PASSIVE_SINK_RATE = 2.0f;
    private static final float RING_RADIUS_SCALE = 0.65f;
    private static final int PERFECT_ZONE_POINTS = 10;
    private static final int GOOD_ZONE_POINTS = 5;
    private long lastPassiveSinkTime;
    private int currentMovePoints = 0;
    private static final float MAX_PASSIVE_SINK_RATE = 8.0f;
    private static final float MIN_PASSIVE_SINK_RATE = 1.0f;
    private static final int MAX_PERFECT_ZONE_POINTS = 20;
    private static final int MIN_PERFECT_ZONE_POINTS = 6;
    private static final int MAX_GOOD_ZONE_POINTS = 10;
    private static final int MIN_GOOD_ZONE_POINTS = 3;
    private static final float SPEED_INCREASE_PER_HIT = 1.0f;
    private static final float SPEED_DECREASE_ON_MISS = 0.2f;
    private float currentSpeedModifier = 0.0f;
    private static final float MAX_CIRCLE_SPEED = 20.0f;
    private final boolean isFish;
    private final int fishSize;
    private final int fishWeight;
    private float dynamicPassiveSinkRate;
    private int dynamicPerfectZonePoints;
    private int dynamicGoodZonePoints;
    private final int fishType;
    private final int totalCaught;
    private final int recordSize;
    private final int recordWeight;
    private final ItemStack fishStack;

    public FishingMinigameScreen(ItemStack fishStack, int difficulty, int fishType, boolean isFish, int fishSize, int fishWeight, int totalCaught, int recordSize, int recordWeight) {
        super((Component)Component.m_237115_((String)"screen.fishing_plus.minigame"));
        this.fishStack = fishStack;
        this.isFish = isFish;
        this.fishSize = fishSize;
        this.fishWeight = fishWeight;
        this.fishType = fishType;
        this.totalCaught = totalCaught;
        this.recordSize = recordSize;
        this.recordWeight = recordWeight;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scaleX = (float)this.f_96543_ / 1920.0f;
        this.scaleY = (float)this.f_96544_ / 1080.0f;
        this.uniformScale = Math.min(this.scaleX, this.scaleY);
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.lastUpdateTime = (float)System.currentTimeMillis() / 1000.0f;
        this.lastCircleSpawnTime = System.currentTimeMillis();
        if (this.f_96541_ != null && this.f_96541_.f_91066_ != null) {
            this.f_96541_.f_91066_.f_92062_ = true;
        }
        this.calculateDynamicValues();
    }

    private void calculateDynamicValues() {
        int basePerfectPoints;
        float baseSinkRate;
        if (!this.isFish) {
            this.dynamicPassiveSinkRate = 2.0f;
            this.dynamicPerfectZonePoints = 10;
            this.dynamicGoodZonePoints = 5;
            return;
        }
        FishData.FishGroup group = null;
        switch (this.fishType) {
            case 0: 
            case 1: {
                group = FishData.FishGroup.MEDIUM_FISH;
                break;
            }
            case 2: 
            case 3: {
                group = FishData.FishGroup.SMALL_FISH;
                break;
            }
            default: {
                group = null;
            }
        }
        if (group == null) {
            this.dynamicPassiveSinkRate = 2.0f;
            this.dynamicPerfectZonePoints = 10;
            this.dynamicGoodZonePoints = 5;
            return;
        }
        int baseGoodPoints = switch (group) {
            case FishData.FishGroup.TINY_FISH -> {
                baseSinkRate = 1.0f;
                basePerfectPoints = 18;
                yield 9;
            }
            case FishData.FishGroup.SMALL_FISH -> {
                baseSinkRate = 2.5f;
                basePerfectPoints = 14;
                yield 7;
            }
            case FishData.FishGroup.MEDIUM_FISH -> {
                baseSinkRate = 4.0f;
                basePerfectPoints = 10;
                yield 5;
            }
            case FishData.FishGroup.LARGE_FISH -> {
                baseSinkRate = 6.0f;
                basePerfectPoints = 8;
                yield 4;
            }
            case FishData.FishGroup.GIANT_FISH -> {
                baseSinkRate = 8.0f;
                basePerfectPoints = 6;
                yield 3;
            }
            default -> {
                baseSinkRate = 2.0f;
                basePerfectPoints = 10;
                yield 5;
            }
        };
        float weightPercent = (float)(this.fishWeight - group.getMinWeight()) / (float)(group.getMaxWeight() - group.getMinWeight());
        float sizePercent = (float)(this.fishSize - group.getMinSize()) / (float)(group.getMaxSize() - group.getMinSize());
        weightPercent = Math.max(0.0f, Math.min(1.0f, weightPercent));
        sizePercent = Math.max(0.0f, Math.min(1.0f, sizePercent));
        float variationRange = 0.3f;
        this.dynamicPassiveSinkRate = baseSinkRate * (1.0f + weightPercent * variationRange);
        this.dynamicPerfectZonePoints = (int)((float)basePerfectPoints * (1.0f - sizePercent * variationRange));
        this.dynamicGoodZonePoints = (int)((float)baseGoodPoints * (1.0f - sizePercent * variationRange));
        this.dynamicPerfectZonePoints = Math.max(5, this.dynamicPerfectZonePoints);
        this.dynamicGoodZonePoints = Math.max(2, this.dynamicGoodZonePoints);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.f_96541_ != null && this.f_96541_.f_91066_ != null) {
            this.f_96541_.f_91066_.f_92062_ = false;
        }
    }

    public boolean m_6913_() {
        return true;
    }

    private int scale(int value) {
        return (int)((float)value * this.uniformScale);
    }

    public void m_86600_() {
        long spawnDelay;
        super.m_86600_();
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastPassiveSinkTime) / 1000.0f;
        if (deltaTime >= 1.0f) {
            this.fishPosition = Math.max(0.0f, this.fishPosition - this.dynamicPassiveSinkRate);
            this.lastPassiveSinkTime = currentTime;
        }
        this.updateCircles();
        long l = spawnDelay = (float)currentTime - this.lastUpdateTime < 5000.0f ? 0L : 500L;
        if (currentTime - this.lastCircleSpawnTime >= spawnDelay && this.activeCircles.size() < 4) {
            this.spawnNewCircle();
            this.lastCircleSpawnTime = currentTime;
        }
        if (this.fishPosition >= 92.0f) {
            this.onGameWon();
        } else if (this.fishPosition <= 5.0f) {
            this.onGameLost();
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderCustomBackground(graphics);
        int ringX = (this.f_96543_ - 256) / 2;
        int ringY = (this.f_96544_ - 256) / 2 + -15;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RING);
        graphics.m_280163_(RING, ringX, ringY, 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TARGET_ZONE_GOOD);
        graphics.m_280163_(TARGET_ZONE_GOOD, ringX, ringY, 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TARGET_ZONE_PERFECT);
        graphics.m_280163_(TARGET_ZONE_PERFECT, ringX, ringY, 0.0f, 0.0f, 256, 256, 256, 256);
        this.renderCircles(graphics, ringX, ringY);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOWER_COVER);
        graphics.m_280163_(LOWER_COVER, ringX, ringY + 256 - 64 - 11, 0.0f, 0.0f, 256, 64, 256, 64);
        this.renderProgressBar(graphics);
        MutableComponent text = Component.m_237115_((String)"fishing_plus.minigame.press_space");
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        graphics.m_280614_(this.f_96547_, (Component)text, (this.f_96543_ - textWidth) / 2, this.f_96544_ - 20, 0xFFFFFF, true);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderCustomBackground(GuiGraphics graphics) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        graphics.m_280163_(BACKGROUND, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        RenderSystem.disableBlend();
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderProgressBar(GuiGraphics graphics) {
        RenderSystem.enableBlend();
        int barX = 20;
        int barY = (this.f_96544_ - 200) / 2;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PROGRESS_BAR);
        graphics.m_280163_(PROGRESS_BAR, barX, barY, 0.0f, 0.0f, 32, 200, 32, 200);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PROGRESS_BAR_FILL);
        graphics.m_280163_(PROGRESS_BAR_FILL, barX, barY, 0.0f, 0.0f, 32, 200, 32, 200);
        int fishY = barY + (int)(188.0f * (1.0f - this.fishPosition / 100.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)FISH_INDICATOR);
        graphics.m_280163_(FISH_INDICATOR, barX + 4, fishY, 0.0f, 0.0f, 24, 12, 24, 12);
        RenderSystem.disableBlend();
    }

    private void renderRingSystem(GuiGraphics graphics) {
        RenderSystem.enableBlend();
        int ringX = (this.f_96543_ - 256) / 2;
        int ringY = (this.f_96544_ - 256) / 2;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RING);
        graphics.m_280163_(RING, ringX, ringY, 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TARGET_ZONE_GOOD);
        graphics.m_280163_(TARGET_ZONE_GOOD, ringX, ringY, 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TARGET_ZONE_PERFECT);
        graphics.m_280163_(TARGET_ZONE_PERFECT, ringX, ringY, 0.0f, 0.0f, 256, 256, 256, 256);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOWER_COVER);
        graphics.m_280163_(LOWER_COVER, ringX, ringY + 256 - 64, 0.0f, 0.0f, 256, 64, 256, 64);
        RenderSystem.disableBlend();
    }

    private void renderCircles(GuiGraphics graphics, int ringX, int ringY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CIRCLE);
        int ringRadius = 83;
        for (CircleElement circle : this.activeCircles) {
            int circleX = ringX + 128 + (int)(Math.cos(circle.angle) * (double)(ringRadius - 8)) - 8;
            int circleY = ringY + 128 + 7 + (int)(Math.sin(circle.angle) * (double)(ringRadius - 8)) - 8;
            graphics.m_280163_(CIRCLE, circleX, circleY, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        RenderSystem.disableBlend();
    }

    private void renderLowerCover(GuiGraphics graphics) {
        int scaledRingSize = this.scale(256);
        int coverX = this.centerX - scaledRingSize / 2;
        int coverY = this.centerY + scaledRingSize / 4;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOWER_COVER);
        graphics.m_280163_(LOWER_COVER, coverX, coverY, 0.0f, 0.0f, scaledRingSize, scaledRingSize / 4, 256, 64);
    }

    private void renderItemSlots(GuiGraphics graphics) {
        RenderSystem.enableBlend();
        int slotsX = this.f_96543_ - 32 - 20;
        int slotsY = (this.f_96544_ - 120) / 2;
        RenderSystem.disableBlend();
        for (int i = 0; i < this.displayItems.length && i < 3; ++i) {
            int itemY = slotsY + 16 + i * 28;
            if (this.displayItems[i] == null) continue;
            graphics.m_280480_(this.displayItems[i], slotsX + 8, itemY);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onGameLost();
            return true;
        }
        if (keyCode == 32) {
            this.handleSpacePress();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void handleSpacePress() {
        this.currentMovePoints = 0;
        boolean anyCircleInZone = false;
        Iterator<CircleElement> iterator = this.activeCircles.iterator();
        while (iterator.hasNext()) {
            CircleElement circle = iterator.next();
            if (this.isInPerfectZone(circle.angle)) {
                this.currentMovePoints += this.dynamicPerfectZonePoints;
                this.currentSpeedModifier += 1.0f;
                iterator.remove();
                anyCircleInZone = true;
                continue;
            }
            if (!this.isInTargetZone(circle.angle)) continue;
            this.currentMovePoints += this.dynamicGoodZonePoints;
            this.currentSpeedModifier += 1.0f;
            iterator.remove();
            anyCircleInZone = true;
        }
        if (this.currentMovePoints > 0) {
            this.fishPosition = Math.min(100.0f, this.fishPosition + (float)this.currentMovePoints);
            this.currentSpeedModifier = Math.min(16.0f, this.currentSpeedModifier + 1.0f);
        } else if (!anyCircleInZone) {
            this.fishPosition = Math.max(0.0f, this.fishPosition - 1.0f);
            this.currentSpeedModifier = Math.max(0.0f, this.currentSpeedModifier - 0.2f);
        }
    }

    private void updateCircles() {
        Iterator<CircleElement> iterator = this.activeCircles.iterator();
        while (iterator.hasNext()) {
            CircleElement circle = iterator.next();
            circle.update();
            if (!circle.shouldRemove()) continue;
            iterator.remove();
        }
    }

    private void spawnNewCircle() {
        if (this.activeCircles.size() >= 4) {
            return;
        }
        boolean clockwise = Math.random() < 0.5;
        float startAngle = 1.5707964f;
        this.activeCircles.add(new CircleElement(startAngle += clockwise ? -0.1f : 0.1f, clockwise, this.currentSpeedModifier));
    }

    private boolean isInTargetZone(float angle) {
        float degrees = (float)Math.toDegrees(angle) % 360.0f;
        if (degrees < 0.0f) {
            degrees += 360.0f;
        }
        return degrees >= 240.0f && degrees <= 300.0f;
    }

    private boolean isInPerfectZone(float angle) {
        float degrees = (float)Math.toDegrees(angle) % 360.0f;
        if (degrees < 0.0f) {
            degrees += 360.0f;
        }
        return degrees >= 260.0f && degrees <= 280.0f;
    }

    private void onGameLost() {
        this.currentSpeedModifier = 0.0f;
        this.f_96541_.m_91152_(null);
    }

    private void onGameWon() {
        this.currentSpeedModifier = 0.0f;
        ModMessages.sendToServer(new FishingSuccessC2SPacket(true));
        this.f_96541_.m_91152_((Screen)new FishCaughtScreen(this.fishStack, this.fishSize, this.fishWeight, this.totalCaught, this.recordSize, this.recordWeight));
    }

    private static class CircleElement {
        float angle;
        final boolean clockwise;
        final float baseSpeed;

        CircleElement(float startAngle, boolean clockwise, float speedModifier) {
            this.angle = startAngle;
            this.clockwise = clockwise;
            float randomVariation = (float)(Math.random() * (double)0.8f * 2.0 - (double)0.8f);
            this.baseSpeed = Math.min(20.0f, 4.0f + randomVariation + speedModifier);
        }

        void update() {
            this.angle = this.clockwise ? (float)((double)this.angle + Math.toRadians(this.baseSpeed)) : (float)((double)this.angle - Math.toRadians(this.baseSpeed));
        }

        boolean shouldRemove() {
            float degrees = (float)Math.toDegrees(this.angle) % 360.0f;
            if (degrees < 0.0f) {
                degrees += 360.0f;
            }
            return degrees >= 360.0f || degrees <= 0.0f;
        }
    }
}

