/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.event;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.fishing_plus.capability.PlayerFishStats;
import net.mint_gaming_studios.fishing_plus.capability.PlayerFishStatsProvider;
import net.mint_gaming_studios.fishing_plus.config.ModConfig;
import net.mint_gaming_studios.fishing_plus.fish.FishData;
import net.mint_gaming_studios.fishing_plus.fish.FishStats;
import net.mint_gaming_studios.fishing_plus.network.ModMessages;
import net.mint_gaming_studios.fishing_plus.network.packet.OpenFishCaughtScreenS2CPacket;
import net.mint_gaming_studios.fishing_plus.network.packet.OpenFishingMinigameS2CPacket;

public class FishingEventHandler {
    private static final Map<UUID, FishingHook> activeFishingHooks = new ConcurrentHashMap<UUID, FishingHook>();
    private static final Map<UUID, List<ItemStack>> determinedLoots = new ConcurrentHashMap<UUID, List<ItemStack>>();

    private ItemStack getRodInHand(Player player) {
        TagKey fishingRodsTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/fishing_rods"));
        ItemStack mainHandStack = player.m_21205_();
        ItemStack offHandStack = player.m_21206_();
        if (mainHandStack.m_204117_(fishingRodsTag) || mainHandStack.m_41720_() instanceof FishingRodItem) {
            return mainHandStack;
        }
        if (offHandStack.m_204117_(fishingRodsTag) || offHandStack.m_41720_() instanceof FishingRodItem) {
            return offHandStack;
        }
        return mainHandStack;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onFishBiteMinigame(ItemFishedEvent event) {
        ItemStack displayStack;
        if (!((Boolean)ModConfig.COMMON.ENABLE_MINIGAME.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        event.setCanceled(true);
        event.setResult(Event.Result.DENY);
        activeFishingHooks.put(serverPlayer.m_20148_(), serverPlayer.f_36083_);
        LootTable lootTable = serverPlayer.m_20194_().m_278653_().m_278676_(BuiltInLootTables.f_78720_);
        ItemStack rod = this.getRodInHand((Player)serverPlayer);
        LootParams lootParams = new LootParams.Builder(serverPlayer.m_284548_()).m_287286_(LootContextParams.f_81460_, (Object)serverPlayer.f_36083_.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)rod).m_287286_(LootContextParams.f_81455_, (Object)serverPlayer.f_36083_).m_287239_(serverPlayer.m_36336_()).m_287235_(LootContextParamSets.f_81414_);
        ObjectArrayList possibleLoot = lootTable.m_287195_(lootParams);
        for (ItemStack stack : possibleLoot) {
            FishData.FishProperties props;
            if (!FishData.isFish(stack.m_41720_()) || (props = FishData.generateFishProperties(stack.m_41720_())) == null) continue;
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("FishSize", props.getSize());
            tag.m_128405_("FishWeight", props.getWeight());
            tag.m_128359_("FishRarity", props.calculateRarity().name());
            tag.m_128379_("FishingPlus", true);
        }
        determinedLoots.put(serverPlayer.m_20148_(), (List<ItemStack>)possibleLoot);
        Item caughtFishItem = null;
        ResourceLocation fishResourceLocation = new ResourceLocation("minecraft", "cod");
        boolean isFish = false;
        int size = 0;
        int weight = 0;
        if (!possibleLoot.isEmpty() && FishData.isFish((displayStack = (ItemStack)possibleLoot.get(0)).m_41720_())) {
            isFish = true;
            caughtFishItem = displayStack.m_41720_();
            fishResourceLocation = ForgeRegistries.ITEMS.getKey((Object)caughtFishItem);
            CompoundTag tag = displayStack.m_41783_();
            if (tag != null) {
                size = tag.m_128451_("FishSize");
                weight = tag.m_128451_("FishWeight");
            }
        }
        int difficulty = 1 + serverPlayer.m_217043_().m_188503_(3);
        AtomicInteger totalCaught = new AtomicInteger(0);
        AtomicInteger recordSize = new AtomicInteger(0);
        AtomicInteger recordWeight = new AtomicInteger(0);
        if (isFish && caughtFishItem != null) {
            Item finalCaughtFishItem = caughtFishItem;
            serverPlayer.getCapability(PlayerFishStatsProvider.PLAYER_FISH_STATS).ifPresent(stats -> {
                FishStats fishStats = stats.getFishStats().get(finalCaughtFishItem);
                if (fishStats != null) {
                    totalCaught.set(fishStats.totalCaught());
                    recordSize.set(fishStats.largestSize());
                    recordWeight.set(fishStats.heaviestWeight());
                }
            });
        }
        ModMessages.sendToPlayer(new OpenFishingMinigameS2CPacket(difficulty, fishResourceLocation, isFish, size, weight, totalCaught.get(), recordSize.get(), recordWeight.get()), serverPlayer);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFishBiteVanilla(ItemFishedEvent event) {
        if (((Boolean)ModConfig.COMMON.ENABLE_MINIGAME.get()).booleanValue() || event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack mainFishForScreen = ItemStack.f_41583_;
        for (ItemStack currentStack : event.getDrops()) {
            FishData.FishProperties props;
            if (!FishData.isFish(currentStack.m_41720_()) || (props = FishData.generateFishProperties(currentStack.m_41720_())) == null) continue;
            CompoundTag tag = currentStack.m_41784_();
            tag.m_128405_("FishSize", props.getSize());
            tag.m_128405_("FishWeight", props.getWeight());
            tag.m_128359_("FishRarity", props.calculateRarity().name());
            tag.m_128379_("FishingPlus", true);
            if (mainFishForScreen.m_41619_()) {
                mainFishForScreen = currentStack.m_41777_();
            }
            serverPlayer.getCapability(PlayerFishStatsProvider.PLAYER_FISH_STATS).ifPresent(stats -> stats.updateFishStats(currentStack.m_41720_(), props.getSize(), props.getWeight(), currentStack));
        }
        if (!mainFishForScreen.m_41619_()) {
            ItemStack finalMainFishForScreen = mainFishForScreen;
            Object ref = new Object(){
                int totalCaught = 0;
                int recordSize = 0;
                int recordWeight = 0;
            };
            serverPlayer.getCapability(PlayerFishStatsProvider.PLAYER_FISH_STATS).ifPresent(arg_0 -> FishingEventHandler.lambda$onFishBiteVanilla$2(finalMainFishForScreen, ref, arg_0));
            if (serverPlayer.f_8924_ != null && finalMainFishForScreen.m_41782_()) {
                serverPlayer.f_8924_.execute(() -> FishingEventHandler.lambda$onFishBiteVanilla$3(finalMainFishForScreen, ref, serverPlayer));
            }
        }
    }

    public static FishingHook getActiveFishingHook(Player player) {
        return activeFishingHooks.get(player.m_20148_());
    }

    public static void clearActiveFishingHook(Player player) {
        activeFishingHooks.remove(player.m_20148_());
    }

    public static List<ItemStack> getDeterminedLoot(Player player) {
        return determinedLoots.get(player.m_20148_());
    }

    public static void clearDeterminedLoot(Player player) {
        determinedLoots.remove(player.m_20148_());
    }

    private static /* synthetic */ void lambda$onFishBiteVanilla$3(ItemStack finalMainFishForScreen, 1 ref, ServerPlayer serverPlayer) {
        ModMessages.sendToPlayer(new OpenFishCaughtScreenS2CPacket(finalMainFishForScreen, finalMainFishForScreen.m_41783_().m_128451_("FishSize"), finalMainFishForScreen.m_41783_().m_128451_("FishWeight"), ref.totalCaught, ref.recordSize, ref.recordWeight), serverPlayer);
    }

    private static /* synthetic */ void lambda$onFishBiteVanilla$2(ItemStack finalMainFishForScreen, 1 ref, PlayerFishStats stats) {
        FishStats fishStats = stats.getFishStats().get(finalMainFishForScreen.m_41720_());
        if (fishStats != null) {
            ref.totalCaught = fishStats.totalCaught();
            ref.recordSize = fishStats.largestSize();
            ref.recordWeight = fishStats.heaviestWeight();
        }
    }
}

