/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.fish;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.fishing_plus.tags.ModTags;

public class FishData {
    public static FishGroup getFishGroup(Item item) {
        if (item == Items.f_42526_ || item == Items.f_42527_) {
            return FishGroup.MEDIUM_FISH;
        }
        if (item == Items.f_42528_ || item == Items.f_42529_) {
            return FishGroup.SMALL_FISH;
        }
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
        if (registryName != null) {
            String path = registryName.m_135815_();
            if (path.contains("giant") || path.contains("whale") || path.contains("shark")) {
                return FishGroup.GIANT_FISH;
            }
            if (path.contains("large")) {
                return FishGroup.LARGE_FISH;
            }
            if (path.contains("tiny") || path.contains("minnow")) {
                return FishGroup.TINY_FISH;
            }
            int hashCode = registryName.toString().hashCode();
            FishGroup[] groups = new FishGroup[]{FishGroup.TINY_FISH, FishGroup.SMALL_FISH, FishGroup.MEDIUM_FISH, FishGroup.LARGE_FISH};
            int index = Math.abs(hashCode) % groups.length;
            return groups[index];
        }
        return FishGroup.MEDIUM_FISH;
    }

    public static FishProperties generateFishProperties(Item item) {
        return FishData.generateForGroup(FishData.getFishGroup(item), item);
    }

    private static FishProperties generateForGroup(FishGroup group, Item fishItem) {
        return new FishProperties(group.getRandomSize(), group.getRandomWeight(), fishItem, group);
    }

    public static boolean isFish(Item item) {
        return item.m_7968_().m_204117_(ModTags.FISHES);
    }

    public static enum FishGroup {
        TINY_FISH(5, 10, 10, 50),
        SMALL_FISH(10, 35, 50, 500),
        MEDIUM_FISH(35, 250, 500, 100000),
        LARGE_FISH(200, 1000, 15000, 2000000),
        GIANT_FISH(800, 2000, 100000, 2100000000);

        private final int minSize;
        private final int maxSize;
        private final int minWeight;
        private final int maxWeight;

        private FishGroup(int minSize, int maxSize, int minWeight, int maxWeight) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.minWeight = minWeight;
            this.maxWeight = maxWeight;
        }

        public int getRandomSize() {
            return this.minSize + (int)(Math.random() * (double)(this.maxSize - this.minSize));
        }

        public int getRandomWeight() {
            return this.minWeight + (int)(Math.random() * (double)(this.maxWeight - this.minWeight));
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int getMinWeight() {
            return this.minWeight;
        }

        public int getMaxWeight() {
            return this.maxWeight;
        }
    }

    public static class FishProperties {
        private final int size;
        private final int weight;
        private final Item fishItem;
        private final FishGroup group;

        public FishProperties(int size, int weight, Item fishItem, FishGroup group) {
            this.size = size;
            this.weight = weight;
            this.fishItem = fishItem;
            this.group = group;
        }

        public String getFormattedWeight() {
            if (this.weight >= 1000000) {
                return String.format("%.2f t", (double)this.weight / 1000000.0);
            }
            if (this.weight >= 1000) {
                return String.format("%.1f kg", (double)this.weight / 1000.0);
            }
            return String.format("%d g", this.weight);
        }

        public Rarity calculateRarity() {
            double weightPercentile = (double)(this.weight - this.group.minWeight) / (double)(this.group.maxWeight - this.group.minWeight) * 100.0;
            if (weightPercentile >= 95.0) {
                return Rarity.EPIC;
            }
            if (weightPercentile >= 80.0) {
                return Rarity.RARE;
            }
            if (weightPercentile >= 60.0) {
                return Rarity.UNCOMMON;
            }
            return Rarity.COMMON;
        }

        public void addTooltipInfo(List<Component> tooltip) {
            tooltip.add((Component)Component.m_237110_((String)"item.fishing_plus.fish.tooltip.size", (Object[])new Object[]{this.getFormattedSize()}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"item.fishing_plus.fish.tooltip.weight", (Object[])new Object[]{this.getFormattedWeight()}).m_130940_(ChatFormatting.GRAY));
        }

        public String getFormattedSize() {
            return String.format("%d cm", this.size);
        }

        public Item getFishItem() {
            return this.fishItem;
        }

        public int getSize() {
            return this.size;
        }

        public int getWeight() {
            return this.weight;
        }

        public FishGroup getGroup() {
            return this.group;
        }
    }
}

