/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.item.custom;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.mint_gaming_studios.fishing_plus.client.FishBagMenuProvider;
import net.mint_gaming_studios.fishing_plus.item.custom.FishBagItemHandler;
import org.slf4j.Logger;

public class FishBagItem
extends Item {
    private static final int SLOTS_PER_PAGE = 54;
    private static final int MAX_UPGRADES = 9;
    private static final Logger LOGGER = LogUtils.getLogger();

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (!level.f_46443_) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                if (handler instanceof INBTSerializable) {
                    stack.m_41784_().m_128365_("FishBagInventory", ((INBTSerializable)handler).serializeNBT());
                }
                int occupiedSlots = this.countOccupiedSlots((IItemHandler)handler);
                stack.m_41784_().m_128405_("OccupiedSlots", occupiedSlots);
            });
        }
    }

    public FishBagItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("OccupiedSlots")) {
            int totalSlots = FishBagItem.getTotalSlots(stack);
            if (totalSlots == 0) {
                return 0;
            }
            int occupiedSlots = tag.m_128451_("OccupiedSlots");
            return Math.round(13.0f * (float)occupiedSlots / (float)totalSlots);
        }
        return stack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> {
            int totalSlots = FishBagItem.getTotalSlots(stack);
            if (totalSlots == 0) {
                return 0;
            }
            int occupiedSlots = this.countOccupiedSlots((IItemHandler)handler);
            return Math.round(13.0f * (float)occupiedSlots / (float)totalSlots);
        }).orElse(0);
    }

    public int m_142159_(ItemStack stack) {
        return ChatFormatting.AQUA.m_126665_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            try {
                FishBagMenuProvider provider = new FishBagMenuProvider(stack);
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)provider, provider.getScreenOpeningData());
            }
            catch (Exception e) {
                System.err.println("[FishBag DEBUG] Fehler beim \u00d6ffnen des Men\u00fcs: " + e.getMessage());
                LOGGER.error("[FishBag DEBUG] Fehler beim \u00d6ffnen des Men\u00fcs: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        try {
            CompoundTag tag = stack.m_41783_();
            int occupiedSlots = 0;
            int totalSlots = 54 * (FishBagItem.getCurrentUpgradeLevel(stack) + 1);
            if (tag != null && tag.m_128441_("OccupiedSlots")) {
                occupiedSlots = tag.m_128451_("OccupiedSlots");
            } else {
                IItemHandler itemHandler;
                LazyOptional itemHandlerOptional = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
                if (itemHandlerOptional.isPresent() && (itemHandler = (IItemHandler)itemHandlerOptional.orElse(null)) != null) {
                    occupiedSlots = this.countOccupiedSlots(itemHandler);
                }
            }
            tooltip.add((Component)Component.m_237110_((String)"item.fishing_plus.fish_bag.slot_capacity", (Object[])new Object[]{occupiedSlots, totalSlots}).m_130940_(ChatFormatting.GOLD));
            int currentUpgradeLevel = FishBagItem.getCurrentUpgradeLevel(stack);
            if (currentUpgradeLevel < 9) {
                tooltip.add((Component)Component.m_237110_((String)"item.fishing_plus.fish_bag.upgrades", (Object[])new Object[]{currentUpgradeLevel, 9}).m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.fishing_plus.fish_bag.fully_upgraded").m_130940_(ChatFormatting.GREEN));
            }
        }
        catch (Exception e) {
            tooltip.add((Component)Component.m_237115_((String)"item.fishing_plus.fish_bag.tooltip_error").m_130940_(ChatFormatting.RED));
            System.err.println("Tooltip-Fehler: " + e.getMessage());
        }
    }

    public int countOccupiedSlots(IItemHandler itemHandler) {
        int count = 0;
        int maxSlots = Math.min(itemHandler.getSlots() - 1, FishBagItem.getTotalSlots(this.m_7968_()));
        for (int i = 0; i < maxSlots; ++i) {
            try {
                if (itemHandler.getStackInSlot(i).m_41619_()) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                System.err.println("Fehler beim Z\u00e4hlen des Slots " + i + ": " + e.getMessage());
            }
        }
        return count;
    }

    public static int getCurrentUpgradeLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_("UpgradeLevel");
    }

    public static void setCurrentUpgradeLevel(ItemStack stack, int level) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("UpgradeLevel", Math.min(level, 9));
    }

    public static int getTotalSlots(ItemStack stack) {
        int upgradeLevel = FishBagItem.getCurrentUpgradeLevel(stack);
        return 54 * (upgradeLevel + 1);
    }

    public static ItemStack insertItemIntoFishBag(IItemHandler handler, ItemStack fishBagStack, ItemStack stackToInsert) {
        ItemStack remaining = stackToInsert.m_41777_();
        int upgradedSlots = FishBagItem.getTotalSlots(fishBagStack);
        for (int i = 0; i < upgradedSlots && !remaining.m_41619_() && i < handler.getSlots(); ++i) {
            remaining = handler.insertItem(i, remaining, false);
        }
        return remaining;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FishBagCapabilityProvider(stack, nbt);
    }

    private static class FishBagCapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<IItemHandler> itemHandler;
        private final FishBagItemHandler fishBagItemHandler;
        private final ItemStack container;

        public FishBagCapabilityProvider(ItemStack container, @Nullable CompoundTag nbt) {
            this.container = container;
            this.fishBagItemHandler = new FishBagItemHandler(container);
            this.itemHandler = LazyOptional.of(() -> this.fishBagItemHandler);
            CompoundTag stackTag = container.m_41783_();
            if (stackTag != null && stackTag.m_128425_("FishBagInventory", 10)) {
                this.fishBagItemHandler.deserializeNBT(stackTag.m_128469_("FishBagInventory"));
            } else if (nbt != null) {
                this.fishBagItemHandler.deserializeNBT(nbt);
            }
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.itemHandler.cast());
        }

        public CompoundTag serializeNBT() {
            return this.fishBagItemHandler.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.fishBagItemHandler.deserializeNBT(nbt);
        }
    }
}

