/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.network.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.fishing_plus.client.gui.FishingMinigameScreen;

public class OpenFishingMinigameS2CPacket {
    private final int difficulty;
    private final ResourceLocation fishResourceLocation;
    private final boolean isFish;
    private final int size;
    private final int weight;
    private final int totalCaught;
    private final int recordSize;
    private final int recordWeight;

    public OpenFishingMinigameS2CPacket(int difficulty, ResourceLocation fishResourceLocation, boolean isFish, int size, int weight, int totalCaught, int recordSize, int recordWeight) {
        this.difficulty = difficulty;
        this.fishResourceLocation = fishResourceLocation;
        this.isFish = isFish;
        this.size = size;
        this.weight = weight;
        this.totalCaught = totalCaught;
        this.recordSize = recordSize;
        this.recordWeight = recordWeight;
    }

    public OpenFishingMinigameS2CPacket(FriendlyByteBuf buf) {
        this.difficulty = buf.readInt();
        this.fishResourceLocation = buf.m_130281_();
        this.isFish = buf.readBoolean();
        this.size = buf.readInt();
        this.weight = buf.readInt();
        this.totalCaught = buf.readInt();
        this.recordSize = buf.readInt();
        this.recordWeight = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.difficulty);
        buf.m_130085_(this.fishResourceLocation);
        buf.writeBoolean(this.isFish);
        buf.writeInt(this.size);
        buf.writeInt(this.weight);
        buf.writeInt(this.totalCaught);
        buf.writeInt(this.recordSize);
        buf.writeInt(this.recordWeight);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHandler.handlePacket(this)));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        static void handlePacket(OpenFishingMinigameS2CPacket packet) {
            Minecraft.m_91087_().execute(() -> {
                if (packet.isFish) {
                    Item caughtFishItem = (Item)ForgeRegistries.ITEMS.getValue(packet.fishResourceLocation);
                    if (caughtFishItem == null) {
                        caughtFishItem = Items.f_42526_;
                    }
                    ItemStack caughtStack = new ItemStack((ItemLike)caughtFishItem);
                    CompoundTag nbt = caughtStack.m_41784_();
                    nbt.m_128405_("FishSize", packet.size);
                    nbt.m_128405_("FishWeight", packet.weight);
                    FishingMinigameScreen screen = new FishingMinigameScreen(caughtStack, packet.difficulty, -1, packet.isFish, packet.size, packet.weight, packet.totalCaught, packet.recordSize, packet.recordWeight);
                    Minecraft.m_91087_().m_91152_((Screen)screen);
                }
            });
        }
    }
}

