/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.hud;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SpinHUD {
    @ConfigRange
    @Translation(key="spin_cooldown_x_offset", type=Translation.Type.CONFIGURATION, comments={"Offset to the x position of the spin cooldown indicator"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "spin"}, key="spin_cooldown_x_offset")
    public static Integer spinCooldownXOffset = 0;
    @ConfigRange
    @Translation(key="spin_cooldown_y_offset", type=Translation.Type.CONFIGURATION, comments={"Offset to the y position of the spin cooldown indicator"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "spin"}, key="spin_cooldown_y_offset")
    public static Integer spinCooldownYOffset = 0;
    public static final ResourceLocation ID = DragonSurvival.res("spin_cooldown");
    private static final ResourceLocation SPIN_COOLDOWN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/spin_cooldown.png");

    public static void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker tracker) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null || player.isSpectator()) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        if (!handler.isDragon()) {
            return;
        }
        if (!ServerFlightHandler.isFlying((Player)player) && !ServerFlightHandler.canSwimSpin((Player)player)) {
            return;
        }
        FlightData spin = FlightData.getData((Player)player);
        if (spin.hasSpin && spin.cooldown > 0 && !Minecraft.getInstance().options.hideGui) {
            Window window = Minecraft.getInstance().getWindow();
            int cooldown = ServerFlightHandler.flightSpinCooldown * 20;
            float cooldownProgress = ((float)cooldown - (float)spin.cooldown) / (float)cooldown;
            int x = window.getGuiScaledWidth() / 2 - 33;
            int y = window.getGuiScaledHeight() - 96;
            int width = (int)(cooldownProgress * 62.0f);
            graphics.blit(SPIN_COOLDOWN, x += spinCooldownXOffset.intValue(), y += spinCooldownYOffset.intValue(), 0.0f, 0.0f, 66, 21, 256, 256);
            graphics.blit(SPIN_COOLDOWN, x + 4, y + 1, 4.0f, 21.0f, width, 21, 256, 256);
        }
    }
}

