/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonSkinsScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonSpeciesScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverDisableable;
import by.dragonsurvivalteam.dragonsurvival.registry.data_maps.BodyIcons;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class DragonBodyButton
extends ExtendedButton
implements HoverDisableable {
    @Translation(comments={"You can only change the body type in the altar when changing the dragon's species."})
    private static final String UNAVAILABLE = Translation.Type.GUI.wrap("dragon_body_button.unavailable");
    @Translation(comments={"This body type has not been unlocked yet."})
    private static final String NOT_UNLOCKED = Translation.Type.GUI.wrap("dragon_body_button.not_unlocked");
    private static final ResourceLocation SELECTED_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/icon_skin_on.png");
    private static final ResourceLocation DESELECTED_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/icon_skin_off.png");
    public static final int HOVERED = 1;
    public static final int SELECTED = 2;
    private static final int LOCKED = 3;
    private final Screen screen;
    private final Holder<DragonBody> dragonBody;
    private final ResourceLocation icon;
    private final ResourceLocation bodyLocation;
    private boolean disableHover;
    private final boolean useBackground;
    private final boolean noTooltip;
    private final LockedReason lockedReason;

    public DragonBodyButton(Screen screen, int x, int y, int xSize, int ySize, Holder<DragonBody> dragonBody, LockedReason locked, Button.OnPress action) {
        this(screen, x, y, xSize, ySize, dragonBody, Objects.requireNonNull(dragonBody.getKey()).location(), locked, action, false, false);
    }

    public DragonBodyButton(Screen screen, int x, int y, int xSize, int ySize, Holder<DragonBody> dragonBody, LockedReason locked, Button.OnPress action, boolean useBackground, boolean noTooltip) {
        this(screen, x, y, xSize, ySize, dragonBody, Objects.requireNonNull(dragonBody.getKey()).location(), locked, action, useBackground, noTooltip);
    }

    private DragonBodyButton(Screen screen, int x, int y, int xSize, int ySize, Holder<DragonBody> dragonBody, ResourceLocation location, LockedReason locked, Button.OnPress action, boolean useBackground, boolean noTooltip) {
        super(x, y, xSize, ySize, (Component)Component.empty(), action, DEFAULT_NARRATION);
        if (!noTooltip) {
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)Translation.Type.BODY_DESCRIPTION.wrap(location))));
        }
        ResourceKey species = null;
        if (screen instanceof DragonEditorScreen) {
            DragonEditorScreen dragonEditorScreen = (DragonEditorScreen)screen;
            species = dragonEditorScreen.species.getKey();
        } else if (screen instanceof DragonSpeciesScreen) {
            DragonSpeciesScreen dragonSpeciesScreen = (DragonSpeciesScreen)screen;
            species = dragonSpeciesScreen.species.getKey();
        }
        this.icon = species == null ? ((DragonBody)dragonBody.value()).defaultIcon().orElse(DragonSurvival.MISSING_TEXTURE) : BodyIcons.getIcon(dragonBody, (ResourceKey<DragonSpecies>)species);
        this.screen = screen;
        this.dragonBody = dragonBody;
        this.bodyLocation = location;
        this.lockedReason = locked;
        this.useBackground = useBackground;
        this.noTooltip = noTooltip;
    }

    @Override
    public void disableHover() {
        this.disableHover = true;
    }

    @Override
    public void enableHover() {
        this.disableHover = false;
    }

    public boolean isHovered() {
        return !this.disableHover && super.isHovered();
    }

    public boolean isFocused() {
        return !this.disableHover && super.isFocused();
    }

    public LockedReason lockedReason() {
        return this.lockedReason;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int state = 0;
        if (this.isSelected()) {
            state = 2;
        } else if (this.lockedReason != LockedReason.NONE) {
            state = 3;
        } else if (this.isHoveredOrFocused()) {
            state = 1;
        }
        if (!this.noTooltip) {
            if (state == 3) {
                if (this.lockedReason == LockedReason.NOT_IN_ALTAR) {
                    this.setTooltip(Tooltip.create((Component)Component.translatable((String)UNAVAILABLE)));
                } else if (this.lockedReason == LockedReason.NOT_UNLOCKED) {
                    this.setTooltip(Tooltip.create((Component)Component.translatable((String)NOT_UNLOCKED)));
                }
            } else {
                this.setTooltip(Tooltip.create((Component)Component.translatable((String)Translation.Type.BODY_DESCRIPTION.wrap(this.bodyLocation))));
            }
        }
        if (this.useBackground) {
            ResourceLocation background = state == 2 ? SELECTED_BACKGROUND : DESELECTED_BACKGROUND;
            graphics.blit(background, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, 35, 35);
            graphics.blit(this.icon, this.getX() + 5, this.getY() + 5, 0.0f, (float)(state * 25), 25, 25, 32, 104);
        } else {
            graphics.blit(this.icon, this.getX(), this.getY(), 0.0f, (float)(state * this.height), this.width, this.height, 32, 104);
        }
    }

    private boolean isSelected() {
        Screen screen = this.screen;
        if (screen instanceof DragonEditorScreen) {
            DragonEditorScreen dragonEditorScreen = (DragonEditorScreen)screen;
            return DragonUtils.isBody(this.dragonBody, dragonEditorScreen.body);
        }
        screen = this.screen;
        if (screen instanceof DragonSkinsScreen) {
            DragonSkinsScreen skinsScreen = (DragonSkinsScreen)screen;
            return DragonUtils.isBody(this.dragonBody, skinsScreen.handler.body());
        }
        return false;
    }

    public static enum LockedReason {
        NOT_UNLOCKED,
        NOT_IN_ALTAR,
        NONE;

    }
}

