/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.editor_part_selector;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.editor_part_selector.HueSelectorComponent;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.loader.DragonPartLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonPart;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class ColorSelectorButton
extends ExtendedButton {
    public final SkinLayer layer;
    private final DragonEditorScreen screen;
    private HueSelectorComponent hueComponent;
    private Renderable renderButton;
    private final int xSize;
    public boolean toggled;
    private final boolean opensRight;
    private final boolean opensUp;
    private static final ResourceLocation BUTTON_HUE_UNCHANGED = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/hue_unchanged.png");
    private static final ResourceLocation BUTTON_HUE_CHANGED = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/editor/hue_changed.png");

    public ColorSelectorButton(DragonEditorScreen screen, SkinLayer layer, int x, int y, int xSize, int ySize, boolean opensRight, boolean opensUp) {
        super(x, y, xSize, ySize, (Component)Component.empty(), action -> {});
        this.xSize = xSize;
        this.screen = screen;
        this.layer = layer;
        this.opensRight = opensRight;
        this.opensUp = opensUp;
        this.visible = true;
    }

    public HueSelectorComponent getHueComponent() {
        return this.hueComponent;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.active = !((DragonStageCustomization)this.screen.preset.get((ResourceKey<DragonStage>)this.screen.stage.getKey()).get()).defaultSkin;
        String parKey = ((LayerSettings)((DragonStageCustomization)this.screen.preset.get((ResourceKey<DragonStage>)this.screen.stage.getKey()).get()).layerSettings.get((Object)((Object)this.layer)).get()).partKey;
        DragonPart part = DragonPartLoader.getDragonPart(this.layer, DragonEditorScreen.HANDLER.speciesKey(), DragonEditorScreen.HANDLER.body(), parKey);
        boolean bl = this.visible = part != null && !Objects.equals(part.key(), "none") && part.isColorable();
        if (this.visible) {
            LayerSettings layerSettings = (LayerSettings)((DragonStageCustomization)this.screen.preset.get((ResourceKey<DragonStage>)this.screen.stage.getKey()).get()).layerSettings.get((Object)this.layer).get();
            if (layerSettings.modifiedColor || layerSettings.glowing) {
                guiGraphics.blit(BUTTON_HUE_CHANGED, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            } else {
                guiGraphics.blit(BUTTON_HUE_UNCHANGED, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        }
        if (!(!this.toggled || this.visible && (this.isMouseOver(mouseX, mouseY) || this.hueComponent != null && this.hueComponent.isMouseOver(mouseX, mouseY)))) {
            this.toggled = false;
            this.screen.children().removeIf(s -> s == this.hueComponent);
            this.screen.renderables.removeIf(s -> s == this.renderButton);
        }
    }

    @NotNull
    public Component getMessage() {
        return Component.empty();
    }

    public void onPress() {
        if (!this.toggled) {
            String partKey = ((LayerSettings)((DragonStageCustomization)this.screen.preset.get((ResourceKey<DragonStage>)this.screen.stage.getKey()).get()).layerSettings.get((Object)((Object)this.layer)).get()).partKey;
            DragonPart part = DragonPartLoader.getDragonPart(this.layer, DragonEditorScreen.HANDLER.speciesKey(), DragonEditorScreen.HANDLER.body(), partKey);
            if (part == null) {
                return;
            }
            this.renderButton = new ExtendedButton(0, 0, 0, 0, (Component)Component.empty(), action -> {}){

                public void renderWidget(@NotNull GuiGraphics guiGraphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
                    this.visible = false;
                    this.active = false;
                    if (ColorSelectorButton.this.hueComponent != null) {
                        ColorSelectorButton.this.hueComponent.visible = ColorSelectorButton.this.visible;
                        if (ColorSelectorButton.this.hueComponent.visible) {
                            ColorSelectorButton.this.hueComponent.render(guiGraphics, p_230430_2_, p_230430_3_, p_230430_4_);
                        }
                    }
                }
            };
            int xOffset = this.opensRight ? this.getX() + this.xSize : this.getX() - 120;
            int yOffset = this.opensUp ? 0 : -60;
            this.hueComponent = new HueSelectorComponent(this.screen, xOffset, this.getY() + yOffset, 120, 90, this.layer);
            ((ScreenAccessor)((Object)this.screen)).dragonSurvival$children().addFirst((GuiEventListener)this.hueComponent);
            ((ScreenAccessor)((Object)this.screen)).dragonSurvival$children().add((GuiEventListener)this.hueComponent);
            this.screen.renderables.add(this.renderButton);
        } else {
            this.screen.children().removeIf(s -> s == this.hueComponent);
            this.screen.renderables.removeIf(s -> s == this.renderButton);
        }
        this.toggled = !this.toggled;
    }
}

