/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonEmoteScreen;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.network.emotes.SyncEmote;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEmoteKeybindings;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmote;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EmoteComponent {
    @Translation(comments={"Bound to: %s"})
    private static final String BOUND_TO = Translation.Type.GUI.wrap("emotes.bound_to");
    @Translation(comments={"Set Keybind"})
    private static final String UNBOUND = Translation.Type.GUI.wrap("emotes.unbound");
    private static final ResourceLocation PLAY_OFF = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/play_off.png");
    private static final ResourceLocation PLAY_ON = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/play_on.png");
    private static final ResourceLocation KEYBIND_OFF = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/keybind_off.png");
    private static final ResourceLocation KEYBIND_ON = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/keybind_on.png");
    private final ExtendedButton isPlayingButton;
    private final ExtendedButton keybindingButton;
    private final ExtendedButton emoteButton;
    private final DragonEmote emote;

    public EmoteComponent(final DragonEmoteScreen screen, int xPos, int yPos, final DragonEmote emote) {
        this.emote = emote;
        this.emoteButton = new ExtendedButton(this, xPos + 10, yPos - 3, 115, 12, (Component)Component.empty(), button -> {
            DragonEntity dragon = ClientDragonRenderer.getDragon((Player)Minecraft.getInstance().player);
            if (dragon == null) {
                return;
            }
            if (dragon.isPlayingEmote(emote)) {
                dragon.stopEmote(emote);
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncEmote(Minecraft.getInstance().player.getId(), emote, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                dragon.beginPlayingEmote(emote);
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncEmote(Minecraft.getInstance().player.getId(), emote, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                FormattedText buttonText = Minecraft.getInstance().font.ellipsize((FormattedText)this.getMessage(), this.width + 26);
                int color = this.isHovered() ? 0xFFFFA0 : this.getFGColor();
                TextRenderUtil.drawScaledText(guiGraphics, this.getX(), (float)this.getY() + (float)(this.height - 8) / 2.0f, 0.8f, buttonText.getString(), color);
            }
        };
        this.emoteButton.setMessage(emote.name());
        this.isPlayingButton = new ExtendedButton(this, xPos, yPos - 1, 6, 6, (Component)Component.empty(), button -> {
            DragonEntity dragon = ClientDragonRenderer.getDragon((Player)Minecraft.getInstance().player);
            if (dragon == null) {
                return;
            }
            if (dragon.isPlayingEmote(emote)) {
                dragon.stopEmote(emote);
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncEmote(Minecraft.getInstance().player.getId(), emote, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                dragon.beginPlayingEmote(emote);
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncEmote(Minecraft.getInstance().player.getId(), emote, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                ResourceLocation texture = DragonSurvival.PROXY.isPlayingEmote((Player)Minecraft.getInstance().player, emote) ? PLAY_ON : PLAY_OFF;
                guiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, 6, 6, 14, 14);
            }
        };
        this.keybindingButton = new ExtendedButton(this, xPos + 126, yPos - 1, 6, 6, (Component)Component.empty(), button -> {
            screen.currentlyKeybinding = emote.key();
        }){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                ResourceLocation texture = emote.key().equals(screen.currentlyKeybinding) ? KEYBIND_ON : KEYBIND_OFF;
                guiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, 6, 6, 14, 14);
            }
        };
        this.refreshKeybinding();
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(this.isPlayingButton);
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(this.keybindingButton);
        ((ScreenAccessor)((Object)screen)).dragonSurvival$addRenderableWidget(this.emoteButton);
    }

    public void refreshKeybinding() {
        int keyCode = DSEmoteKeybindings.EMOTE_KEYBINDS.getKey(this.emote.key());
        if (keyCode != -1) {
            InputConstants.Key input = InputConstants.Type.KEYSYM.getOrCreate(keyCode);
            Component displayName = input.getValue() > 4 ? input.getDisplayName() : Component.literal((String)("M" + (input.getValue() + 1)));
            this.keybindingButton.setTooltip(Tooltip.create((Component)Component.translatable((String)BOUND_TO, (Object[])new Object[]{displayName})));
        } else {
            this.keybindingButton.setTooltip(Tooltip.create((Component)Component.translatable((String)UNBOUND)));
        }
    }

    public List<AbstractWidget> children() {
        return List.of(this.isPlayingButton, this.keybindingButton, this.emoteButton);
    }
}

