/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.KeyHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.LevelRendererAccess;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncLargeDragonDestruction;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncMultiMining;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.SortedSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT})
public class DragonDestructionHandler {
    public static BlockPos centerOfDestruction = BlockPos.ZERO;

    @SubscribeEvent
    public static void renderAdditionalBreakProgress(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            int progress;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player.isCrouching()) {
                return;
            }
            int radius = (int)player.getAttributeValue(DSAttributes.BLOCK_BREAK_RADIUS);
            if (radius < 1) {
                return;
            }
            DragonStateHandler handler = DragonStateProvider.getData((Player)player);
            if (handler.multiMining == DragonStateHandler.MultiMining.DISABLED) {
                return;
            }
            Vec3 cameraPosition = event.getCamera().getPosition();
            double x = cameraPosition.x();
            double y = cameraPosition.y();
            double z = cameraPosition.z();
            LevelRendererAccess access = (LevelRendererAccess)event.getLevelRenderer();
            SortedSet set = (SortedSet)access.dragonSurvival$getDestructionProgress().get(centerOfDestruction.asLong());
            int n = progress = set != null ? ((BlockDestructionProgress)set.last()).getProgress() : -1;
            if (progress == -1) {
                return;
            }
            float centerSpeed = access.dragonSurvival$getLevel().getBlockState(centerOfDestruction).getDestroySpeed((BlockGetter)access.dragonSurvival$getLevel(), centerOfDestruction);
            BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)centerOfDestruction.getCenter(), (double)radius, (double)radius, (double)radius)).forEach(offsetPosition -> {
                double zDistance;
                double yDistance;
                double xDistance = (double)offsetPosition.getX() - x;
                if (!(xDistance * xDistance + (yDistance = (double)offsetPosition.getY() - y) * yDistance + (zDistance = (double)offsetPosition.getZ() - z) * zDistance > 1024.0)) {
                    BlockState state = access.dragonSurvival$getLevel().getBlockState(offsetPosition);
                    float speed = state.getDestroySpeed((BlockGetter)access.dragonSurvival$getLevel(), offsetPosition);
                    if (speed == -1.0f || speed > centerSpeed) {
                        return;
                    }
                    event.getPoseStack().pushPose();
                    event.getPoseStack().translate((double)offsetPosition.getX() - x, (double)offsetPosition.getY() - y, (double)offsetPosition.getZ() - z);
                    PoseStack.Pose lastPose = event.getPoseStack().last();
                    SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(access.dragonSurvival$getRenderBuffers().crumblingBufferSource().getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(progress)), lastPose, 1.0f);
                    ModelData modelData = access.dragonSurvival$getLevel().getModelData(offsetPosition);
                    Minecraft.getInstance().getBlockRenderer().renderBreakingTexture(state, offsetPosition, (BlockAndTintGetter)access.dragonSurvival$getLevel(), event.getPoseStack(), (VertexConsumer)consumer, modelData);
                    event.getPoseStack().popPose();
                }
            });
        }
    }

    public static void toggleDestructionMode(@Nullable Pair<Player, DragonStateHandler> data) {
        if (data == null) {
            return;
        }
        DragonStateHandler handler = (DragonStateHandler)data.getSecond();
        MiscCodecs.DestructionData destructionData = ((DragonStage)handler.stage().value()).destructionData().orElse(null);
        if (destructionData == null || !destructionData.isDestructionAllowed(handler.getGrowth())) {
            return;
        }
        handler.largeDragonDestruction = Functions.cycleEnum(handler.largeDragonDestruction);
        ((Player)data.getFirst()).displayClientMessage(KeyHandler.cycledEnum(handler.largeDragonDestruction), true);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncLargeDragonDestruction(handler.largeDragonDestruction), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void toggleMultiMining(@Nullable Pair<Player, DragonStateHandler> data) {
        if (data == null) {
            return;
        }
        if (((Player)data.getFirst()).getAttributeValue(DSAttributes.BLOCK_BREAK_RADIUS) < 1.0) {
            return;
        }
        DragonStateHandler handler = (DragonStateHandler)data.getSecond();
        handler.multiMining = Functions.cycleEnum(handler.multiMining);
        ((Player)data.getFirst()).displayClientMessage(KeyHandler.cycledEnum(handler.multiMining), true);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncMultiMining(handler.multiMining), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

