/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ClientConfig;
import by.dragonsurvivalteam.dragonsurvival.input.Keybind;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncBeginCast;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncStopCast;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientCastingHandler {
    private static final Keybind[] slotKeybinds = new Keybind[]{Keybind.ABILITY1, Keybind.ABILITY2, Keybind.ABILITY3, Keybind.ABILITY4};

    @SubscribeEvent
    private static void handleMouseInput(InputEvent.MouseButton.Pre event) {
        ClientCastingHandler.handleCastingInput(InputConstants.Type.MOUSE.getOrCreate(event.getButton()), event.getAction());
    }

    @SubscribeEvent
    private static void handleKeyInput(InputEvent.Key event) {
        ClientCastingHandler.handleCastingInput(InputConstants.getKey((int)event.getKey(), (int)event.getScanCode()), event.getAction());
    }

    private static void handleCastingInput(InputConstants.Key input, int action) {
        Minecraft instance = Minecraft.getInstance();
        if (instance.screen != null || instance.player == null || instance.level == null) {
            return;
        }
        LocalPlayer player = instance.player;
        if (player.isSpectator() || !DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        if (action == 1) {
            ClientCastingHandler.handleVisibilityToggle((Player)player, input);
            ClientCastingHandler.handleSlotSelection((Player)player, input);
            ClientCastingHandler.beginCast((Player)player, input);
        } else if (action == 0) {
            ClientCastingHandler.stopCast((Player)player, input);
        }
    }

    private static void handleVisibilityToggle(Player player, InputConstants.Key input) {
        MagicData magicData = MagicData.getData(player);
        if (Keybind.TOGGLE_ABILITIES.matches(input)) {
            magicData.setRenderAbilities(!magicData.shouldRenderAbilities());
        }
    }

    private static void handleSlotSelection(Player player, InputConstants.Key input) {
        int lastSelectedSlot;
        MagicData magicData = MagicData.getData(player);
        int selectedSlot = lastSelectedSlot = magicData.getSelectedAbilitySlot();
        if (Keybind.NEXT_ABILITY.matches(input)) {
            selectedSlot = (selectedSlot + 1) % slotKeybinds.length;
        } else if (Keybind.PREVIOUS_ABILITY.matches(input)) {
            selectedSlot = (selectedSlot - 1 + slotKeybinds.length) % slotKeybinds.length;
        }
        for (int i = 0; i < slotKeybinds.length; ++i) {
            if (!slotKeybinds[i].matches(input)) continue;
            selectedSlot = i;
            break;
        }
        if (selectedSlot != lastSelectedSlot) {
            if (magicData.isCasting()) {
                magicData.stopCasting(player);
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncStopCast(player.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            magicData.setSelectedAbilitySlot(selectedSlot);
        }
    }

    private static void beginCast(Player player, InputConstants.Key input) {
        MagicData magicData = MagicData.getData(player);
        int selectedSlot = magicData.getSelectedAbilitySlot();
        if (ClientCastingHandler.getKey(magicData.getSelectedAbilitySlot()).matches(input) && !magicData.isCasting() && magicData.attemptCast(player, selectedSlot)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncBeginCast(player.getId(), selectedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void stopCast(Player player, InputConstants.Key input) {
        MagicData magicData = MagicData.getData(player);
        if (ClientCastingHandler.getKey(magicData.getSelectedAbilitySlot()).isReleased(input)) {
            if (magicData.isCasting()) {
                magicData.stopCasting(player);
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncStopCast(player.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            magicData.setErrorMessageSent(false);
        }
    }

    private static Keybind getKey(int selectedSlot) {
        if (ClientConfig.alternateCastMode.booleanValue()) {
            return slotKeybinds[selectedSlot];
        }
        return Keybind.USE_ABILITY;
    }
}

