/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.creatures;

import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.KnightEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;

public class CustomBlockAndItemGeoLayer<T extends GeoAnimatable>
extends BlockAndItemGeoLayer<T> {
    public CustomBlockAndItemGeoLayer(GeoRenderer<T> renderer) {
        super(renderer);
    }

    protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        if (animatable instanceof KnightEntity) {
            if (bone.getName().equalsIgnoreCase("left_item")) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.translate(0.0f, 0.0f, -1.0f);
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            }
        }
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)animatable;
            Minecraft.getInstance().getItemRenderer().renderStatic(livingEntity, stack, this.getTransformTypeForStack(bone, stack, animatable), false, poseStack, bufferSource, livingEntity.level(), packedLight, packedOverlay, livingEntity.getId());
        } else {
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, this.getTransformTypeForStack(bone, stack, animatable), packedLight, packedOverlay, poseStack, bufferSource, (Level)Minecraft.getInstance().level, (int)this.renderer.getInstanceId(animatable));
        }
        poseStack.popPose();
    }

    protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, T animatable) {
        if (bone.getName().equalsIgnoreCase("left_item")) {
            return ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        }
        if (bone.getName().equalsIgnoreCase("right_item")) {
            return ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        }
        return ItemDisplayContext.NONE;
    }

    @Nullable
    protected ItemStack getStackForBone(GeoBone bone, T animatable) {
        if (bone != null && animatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)animatable;
            if (bone.getName().equalsIgnoreCase("left_item")) {
                return livingEntity.getOffhandItem();
            }
            if (bone.getName().equalsIgnoreCase("right_item")) {
                return livingEntity.getMainHandItem();
            }
        }
        return null;
    }
}

