/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import software.bernie.geckolib.animation.RawAnimation;

@EventBusSubscriber(value={Dist.CLIENT})
public class AnimationTickTimer {
    public static final CopyOnWriteArrayList<AnimationTickTimer> TIMERS = new CopyOnWriteArrayList();
    protected final ConcurrentHashMap<String, Double> animationTimes = new ConcurrentHashMap();

    @SubscribeEvent
    public static void onTick(ClientTickEvent.Pre event) {
        for (AnimationTickTimer timer : TIMERS) {
            ((ConcurrentHashMap.KeySetView)timer.animationTimes.keySet()).forEach(key -> {
                timer.animationTimes.computeIfPresent((String)key, (animation, tick) -> tick - 1.0);
                if (timer.animationTimes.get(key) <= 0.0) {
                    timer.animationTimes.remove(key);
                }
            });
            if (!timer.animationTimes.isEmpty()) continue;
            TIMERS.remove(timer);
        }
    }

    public boolean isPresent(String animation) {
        return this.animationTimes.containsKey(animation);
    }

    public boolean isPresent(RawAnimation animation) {
        assert (animation.getAnimationStages().size() == 1);
        return this.animationTimes.containsKey(((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName());
    }

    public double getDuration(String animation) {
        return this.animationTimes.getOrDefault(animation, 0.0);
    }

    public double getDuration(RawAnimation animation) {
        assert (animation.getAnimationStages().size() == 1);
        return this.getDuration(((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName());
    }

    public void putAnimation(String animation, Double ticks) {
        this.putDuration(animation, ticks);
        if (!TIMERS.contains(this)) {
            TIMERS.add(this);
        }
    }

    public void putAnimation(RawAnimation animation, Double ticks) {
        assert (animation.getAnimationStages().size() == 1);
        this.putDuration(((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName(), ticks);
        if (!TIMERS.contains(this)) {
            TIMERS.add(this);
        }
    }

    protected void putDuration(String animation, Double ticks) {
        this.animationTimes.put(animation, ticks);
    }
}

