/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

@EventBusSubscriber(value={Dist.CLIENT})
public class CustomizationFileHandler {
    public static final Function<Integer, String> FILE_NAME = slot -> "saved_customizations_" + slot + ".nbt";
    public static final String DIRECTORY = "dragon-survival";
    public static final int STARTING_SLOT = 1;
    public static final int MAX_SAVE_SLOTS = 5;
    private static final String CUSTOMIZATION = "customization";
    private static final String DRAGON_SPECIES = "dragon_species";
    private static final String DRAGON_MODEL = "dragon_model";
    private static final Map<Integer, File> savedFileForSlot = new HashMap<Integer, File>();
    private static final Map<Integer, SavedCustomization> savedCustomizations = new HashMap<Integer, SavedCustomization>();
    private static boolean hasInitialized;

    @SubscribeEvent
    public static void initializeSavedCustomizations(EntityJoinLevelEvent event) {
        CustomizationFileHandler.loadSavedCustomizations(event.getLevel().registryAccess());
    }

    public static void loadSavedCustomizations(RegistryAccess access) {
        if (hasInitialized) {
            return;
        }
        File directory = new File(FMLPaths.GAMEDIR.get().toFile(), DIRECTORY);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        for (int slot = 1; slot <= 5; ++slot) {
            File savedFile = new File(directory, FILE_NAME.apply(slot));
            savedFileForSlot.put(slot, savedFile);
            if (!savedFile.exists()) continue;
            try {
                CompoundTag nbt = NbtIo.read((Path)savedFile.toPath());
                if (nbt == null) {
                    DragonSurvival.LOGGER.warn("Could not read saved skin from the file [{}]", (Object)savedFile);
                    continue;
                }
                SavedCustomization savedCustomization = SavedCustomization.fromNbt((HolderLookup.Provider)access, nbt);
                if (savedCustomization == null) {
                    DragonSurvival.LOGGER.warn("Could not read saved skin from the file [{}]", (Object)savedFile);
                    continue;
                }
                savedCustomizations.put(slot, SavedCustomization.fromNbt((HolderLookup.Provider)access, nbt));
                continue;
            }
            catch (IOException exception) {
                DragonSurvival.LOGGER.warn("An error occurred while processing the file [{}]", (Object)savedFile, (Object)exception);
            }
        }
        hasInitialized = true;
    }

    public static void save(DragonStateHandler handler, int slot, RegistryAccess access) {
        if (!hasInitialized) {
            CustomizationFileHandler.loadSavedCustomizations(access);
        }
        SavedCustomization savedCustomization = SavedCustomization.fromHandler(handler);
        try {
            NbtIo.write((CompoundTag)savedCustomization.serializeNBT((HolderLookup.Provider)access), (Path)savedFileForSlot.get(slot).toPath());
        }
        catch (IOException exception) {
            DragonSurvival.LOGGER.error("An error occurred while trying to save the dragon skin", (Throwable)exception);
        }
        savedCustomizations.put(slot, savedCustomization);
    }

    public static SavedCustomization load(int slot, RegistryAccess access) {
        if (!hasInitialized) {
            CustomizationFileHandler.loadSavedCustomizations(access);
        }
        return savedCustomizations.get(slot);
    }

    public static class SavedCustomization
    implements INBTSerializable<CompoundTag> {
        private DragonStageCustomization customization;
        private ResourceKey<DragonSpecies> dragonSpecies;
        private ResourceLocation dragonModel;

        public SavedCustomization(DragonStageCustomization customization, ResourceKey<DragonSpecies> dragonSpecies, ResourceLocation dragonModel) {
            this.customization = customization;
            this.dragonSpecies = dragonSpecies;
            this.dragonModel = dragonModel;
        }

        public SavedCustomization() {
        }

        public static SavedCustomization fromHandler(DragonStateHandler handler) {
            DragonStageCustomization newCustomization = new DragonStageCustomization();
            newCustomization.deserializeNBT((HolderLookup.Provider)DragonSurvival.PROXY.getAccess(), handler.getCurrentStageCustomization().serializeNBT((HolderLookup.Provider)DragonSurvival.PROXY.getAccess()));
            return new SavedCustomization(newCustomization, handler.speciesKey(), ((DragonBody)handler.body().value()).model());
        }

        public static SavedCustomization fromNbt(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            SavedCustomization customization = new SavedCustomization();
            customization.deserializeNBT(provider, nbt);
            if (customization.customization == null || customization.dragonSpecies == null || customization.dragonModel == null) {
                return null;
            }
            return customization;
        }

        public @UnknownNullability CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            nbt.put(CustomizationFileHandler.CUSTOMIZATION, (Tag)this.customization.serializeNBT(provider));
            nbt.putString(CustomizationFileHandler.DRAGON_SPECIES, this.dragonSpecies.location().toString());
            nbt.putString(CustomizationFileHandler.DRAGON_MODEL, this.dragonModel.toString());
            return nbt;
        }

        public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            this.customization = new DragonStageCustomization();
            if (nbt.contains(CustomizationFileHandler.CUSTOMIZATION)) {
                this.customization.deserializeNBT(provider, nbt.getCompound(CustomizationFileHandler.CUSTOMIZATION));
            }
            if (nbt.contains(CustomizationFileHandler.DRAGON_SPECIES)) {
                this.dragonSpecies = ResourceKey.create(DragonSpecies.REGISTRY, (ResourceLocation)ResourceLocation.parse((String)nbt.getString(CustomizationFileHandler.DRAGON_SPECIES)));
            }
            if (nbt.contains(CustomizationFileHandler.DRAGON_MODEL)) {
                this.dragonModel = ResourceLocation.parse((String)nbt.getString(CustomizationFileHandler.DRAGON_MODEL));
            }
        }

        public DragonStageCustomization getCustomization() {
            return this.customization;
        }

        public ResourceKey<DragonSpecies> getDragonSpecies() {
            return this.dragonSpecies;
        }

        public ResourceLocation getDragonModel() {
            return this.dragonModel;
        }
    }
}

