/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.util;

import by.dragonsurvivalteam.dragonsurvival.client.render.VisionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.NotNull;

public class ClientFluidTypeExtensionsWrapper
implements IClientFluidTypeExtensions {
    private final IClientFluidTypeExtensions original;
    private final VisionHandler.VisionType type;

    public ClientFluidTypeExtensionsWrapper(IClientFluidTypeExtensions original, VisionHandler.VisionType type) {
        this.original = original;
        this.type = type;
    }

    @NotNull
    public ResourceLocation getStillTexture() {
        return this.original.getStillTexture();
    }

    @NotNull
    public ResourceLocation getFlowingTexture() {
        return this.original.getFlowingTexture();
    }

    public ResourceLocation getOverlayTexture() {
        return this.original.getOverlayTexture();
    }

    public ResourceLocation getRenderOverlayTexture(@NotNull Minecraft minecraft) {
        return this.original.getRenderOverlayTexture(minecraft);
    }

    public int getTintColor() {
        int color = this.original.getTintColor();
        if (VisionHandler.hasVision(this.type)) {
            return color & 0xFFFFFF | 0x5A000000;
        }
        return color;
    }

    public int getTintColor(@NotNull FluidState state, @NotNull BlockAndTintGetter getter, @NotNull BlockPos position) {
        int color = this.original.getTintColor(state, getter, position);
        if (VisionHandler.hasVision(this.type)) {
            return color & 0xFFFFFF | 0x5A000000;
        }
        return color;
    }
}

