/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands.arguments;

import by.dragonsurvivalteam.dragonsurvival.commands.arguments.DragonSpeciesArgument;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DragonStageArgument
implements ArgumentType<Holder<DragonStage>> {
    public static final String ID = "dragon_stage";
    private final HolderLookup.RegistryLookup<DragonStage> lookup;
    private final CommandBuildContext context;

    public DragonStageArgument(CommandBuildContext context) {
        this.lookup = context.lookupOrThrow(DragonStage.REGISTRY);
        this.context = context;
    }

    @Nullable
    public Holder<DragonStage> parse(StringReader reader) throws CommandSyntaxException {
        Optional optional = this.lookup.get(ResourceKey.create(DragonStage.REGISTRY, (ResourceLocation)ResourceLocation.read((StringReader)reader)));
        return optional.orElse(null);
    }

    public static Holder<DragonStage> get(CommandContext<?> context) {
        return (Holder)context.getArgument(ID, Holder.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList suggestions = new ArrayList();
        Holder<DragonSpecies> species = DragonSpeciesArgument.get(context);
        if (species != null) {
            HolderSet<DragonStage> stages = ((DragonSpecies)species.value()).getStages((HolderLookup.Provider)this.context);
            stages.forEach(stage -> suggestions.add(stage.getRegisteredName()));
        } else {
            this.lookup.listElementIds().forEach(element -> suggestions.add(element.location().toString()));
        }
        return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
    }
}

