/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkeletonPieceBlock
extends Block
implements SimpleWaterloggedBlock {
    @Translation(comments={"Dragon Bones"})
    public static final String DRAGON_BONES = "item.dragonsurvival.dragon_bone";
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Type type;
    public static final MapCodec<SkeletonPieceBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Type.CODEC.fieldOf("type").forGetter(SkeletonPieceBlock::type), (App)SkeletonPieceBlock.propertiesCodec()).apply((Applicative)instance, SkeletonPieceBlock::new));

    public SkeletonPieceBlock(Type type, BlockBehaviour.Properties p_56319_) {
        super(p_56319_);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public Type type() {
        return this.type;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch (this.type.ordinal()) {
            case 0 -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case 1 -> Block.box((double)-12.0, (double)0.0, (double)-12.0, (double)32.0, (double)16.0, (double)32.0);
            case 8 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
            case 4 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
            default -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
        };
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return Shapes.empty();
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
        pBuilder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (state.hasProperty((Property)FACING)) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
        }
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    @NotNull
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @NotNull
    public String getDescriptionId() {
        return DRAGON_BONES;
    }

    public static enum Type implements StringRepresentable
    {
        CHEST("skeleton_dragon_chest"),
        FULL("skeleton_dragon_full"),
        LEG_1("skeleton_dragon_leg_1"),
        LEG_2("skeleton_dragon_leg_2"),
        LEG_3("skeleton_dragon_leg_3"),
        NECK_1("skeleton_dragon_neck_1"),
        NECK_2("skeleton_dragon_neck_2"),
        NECK_3("skeleton_dragon_neck_3"),
        PELVIS("skeleton_dragon_pelvis"),
        SKULL_1("skeleton_dragon_skull_1"),
        SKULL_2("skeleton_dragon_skull_2"),
        TAIL_1("skeleton_dragon_tail_1"),
        TAIL_2("skeleton_dragon_tail_2"),
        TAIL_3("skeleton_dragon_tail_3"),
        TAIL_4("skeleton_dragon_tail_4");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String pName) {
            this.name = pName;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromValues(Type::values);
        }
    }
}

