/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates.DragonPredicate;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates.DragonStagePredicate;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.phys.Vec3;

public class Condition {
    private static final LootContextParamSet ABILITY_CONTEXT = new LootContextParamSet.Builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.ATTACKING_ENTITY).build();
    private static final LootContextParamSet BLOCK_CONTEXT = new LootContextParamSet.Builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE).optional(LootContextParams.BLOCK_ENTITY).build();
    private static final LootContextParamSet ENTITY_CONTEXT = new LootContextParamSet.Builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).build();
    private static final LootContextParamSet PROJECTILE_CONTEXT = new LootContextParamSet.Builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.ATTACKING_ENTITY).build();
    private static final LootContextParamSet DAMAGE_CONTEXT = new LootContextParamSet.Builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.DAMAGE_SOURCE).optional(LootContextParams.ATTACKING_ENTITY).optional(LootContextParams.DIRECT_ATTACKING_ENTITY).optional(LootContextParams.TOOL).build();

    public static LootContext entityContext(ServerLevel serverLevel, Entity entity) {
        LootParams parameters = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).create(ENTITY_CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    public static LootContext penaltyContext(ServerPlayer dragon) {
        LootParams parameters = new LootParams.Builder(dragon.serverLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)dragon).withParameter(LootContextParams.ORIGIN, (Object)dragon.position()).create(ENTITY_CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    public static LootContext abilityContext(ServerPlayer dragon) {
        return Condition.abilityContext(dragon, (Entity)dragon, dragon.position());
    }

    public static LootContext abilityContext(ServerPlayer attacker, Entity entity, Vec3 origin) {
        LootParams parameters = new LootParams.Builder(attacker.serverLevel()).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)attacker).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)origin).create(ABILITY_CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    public static LootContext blockContext(ServerPlayer dragon, BlockPos position) {
        return Condition.blockContext(dragon, position, dragon.serverLevel().getBlockState(position));
    }

    public static LootContext blockContext(ServerPlayer dragon, BlockPos position, BlockState state) {
        LootParams parameters = new LootParams.Builder(dragon.serverLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)dragon).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)position)).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)dragon.serverLevel().getBlockEntity(position)).create(BLOCK_CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    public static LootContext projectileContext(ServerLevel level, Projectile projectile, Entity target) {
        LootParams parameters = new LootParams.Builder(level).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)projectile).withParameter(LootContextParams.THIS_ENTITY, (Object)target).withParameter(LootContextParams.ORIGIN, (Object)target.position()).create(PROJECTILE_CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    public static LootContext damageContext(ServerLevel level, Entity entity, DamageSource source, ItemStack tool) {
        LootParams parameters = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.TOOL, (Object)tool).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity()).create(DAMAGE_CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    public static LootItemCondition.Builder thisEntity(EntityPredicate predicate) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)predicate);
    }

    public static LootItemCondition.Builder damageSource(DamageSourcePredicate.Builder builder) {
        return DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)builder);
    }

    public static LootItemCondition.Builder tool(ItemPredicate predicate) {
        return () -> new MatchTool(Optional.of(predicate));
    }

    public static ContextAwarePredicate none() {
        return EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().build());
    }

    public static EntityPredicate.Builder dragonSpecies(Holder<DragonSpecies> species) {
        return EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)DragonPredicate.Builder.dragon().species(species).build());
    }

    public static EntityPredicate.Builder dragonStage(Holder<DragonStage> dragonStage) {
        return EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)DragonPredicate.Builder.dragon().stage(dragonStage).build());
    }

    public static EntityPredicate.Builder dragonSizeAtLeast(double min) {
        return EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)DragonPredicate.Builder.dragon().stage(DragonStagePredicate.Builder.start().growthAtLeast(min).build()).build());
    }
}

