/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.ResourceLocationWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;

public record DietEntry(String items, Optional<FoodProperties> properties) {
    public static final float DEFAULT_EAT_SECONDS = 1.6f;
    public static final Codec<DietEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocationWrapper.validatedCodec().fieldOf("items").forGetter(DietEntry::items), (App)FoodProperties.DIRECT_CODEC.optionalFieldOf("properties").forGetter(DietEntry::properties)).apply((Applicative)instance, DietEntry::new));

    public static DietEntry from(ResourceLocation location) {
        return DietEntry.from(location.toString());
    }

    public static DietEntry from(String location) {
        return DietEntry.from(location, null);
    }

    public static DietEntry from(TagKey<Item> tag) {
        return DietEntry.from(tag, null);
    }

    public static DietEntry from(TagKey<Item> tag, FoodProperties properties) {
        return DietEntry.from("#" + String.valueOf(tag.location()), properties);
    }

    public static DietEntry from(Item item) {
        return DietEntry.from(item, null);
    }

    public static DietEntry from(Item item, FoodProperties properties) {
        return DietEntry.from(item.builtInRegistryHolder().getKey().location(), properties);
    }

    public static DietEntry from(ResourceLocation location, FoodProperties properties) {
        return DietEntry.from(location.toString(), properties);
    }

    public static DietEntry from(String location, FoodProperties properties) {
        return new DietEntry(location, Optional.ofNullable(properties));
    }

    public static Map<Item, FoodProperties> map(List<DietEntry> entries) {
        HashMap<Item, FoodProperties> diet = new HashMap<Item, FoodProperties>();
        for (DietEntry entry : entries) {
            ResourceLocationWrapper.map(entry.items(), BuiltInRegistries.ITEM).forEach(resource -> {
                FoodProperties properties;
                Item item = (Item)BuiltInRegistries.ITEM.get(resource);
                if (item != null && (properties = entry.properties.orElse(item.getDefaultInstance().getFoodProperties(null))) != null) {
                    diet.put(item, properties);
                }
            });
        }
        return diet;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DietEntry)) {
            return false;
        }
        DietEntry otherDiet = (DietEntry)other;
        return this.items.equals(otherDiet.items());
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }
}

