/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modification;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncEffectModification;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.EffectModifications;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectModification
extends DurationInstanceBase<EffectModifications, Instance> {
    @Translation(comments={"\u00a76\u25a0 Effect modifications:\u00a7r", " - Duration %s", " - Amplifier %s", "\nAffected effects:"})
    private static final String EFFECT_MODIFICATIONS = Translation.Type.GUI.wrap("effect_modification");
    @Translation(comments={"increased by %s"})
    private static final String INCREASED = Translation.Type.GUI.wrap("effect_modification.increased");
    @Translation(comments={"reduced by %s"})
    private static final String REDUCED = Translation.Type.GUI.wrap("effect_modification.reduced");
    @Translation(comments={"is unmodified"})
    private static final String UNMODIFIED = Translation.Type.GUI.wrap("effect_modification.unmodified");
    public static Modification NONE = new Modification(Modification.ModificationType.ADDITIVE, (LevelBasedValue)LevelBasedValue.constant((float)0.0f));
    public static final Codec<EffectModification> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)DurationInstanceBase.CODEC.fieldOf("base").forGetter(identity -> identity), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.MOB_EFFECT).fieldOf("effects").forGetter(EffectModification::effects), (App)Modification.CODEC.optionalFieldOf("duration_modification", (Object)NONE).forGetter(EffectModification::durationModification), (App)Modification.CODEC.optionalFieldOf("amplifier_modification", (Object)NONE).forGetter(EffectModification::amplifierModification)).apply((Applicative)instance, EffectModification::new));
    private final HolderSet<MobEffect> effects;
    private final Modification durationModification;
    private final Modification amplifierModification;

    public EffectModification(DurationInstanceBase<?, ?> base, HolderSet<MobEffect> effects, Modification durationModification, Modification amplifierModification) {
        super(base);
        this.effects = effects;
        this.durationModification = durationModification;
        this.amplifierModification = amplifierModification;
    }

    public MutableComponent getDescription(int abilityLevel) {
        Component duration = this.getModificationDescription(this.durationModification, abilityLevel, true);
        Component amplifier = this.getModificationDescription(this.amplifierModification, abilityLevel, false);
        MutableComponent description = Component.translatable((String)EFFECT_MODIFICATIONS, (Object[])new Object[]{duration, amplifier});
        for (Holder effect : this.effects) {
            description.append((Component)Component.literal((String)"\n- ").append((Component)DSColors.dynamicValue(Component.translatable((String)((MobEffect)effect.value()).getDescriptionId()))));
        }
        return description;
    }

    private Component getModificationDescription(Modification modification, int abilityLevel, boolean isTime) {
        MutableComponent component;
        float calculated = modification.amount().calculate(abilityLevel);
        if (modification.type() == Modification.ModificationType.MULTIPLICATIVE) {
            String difference = NumberFormat.getPercentInstance().format(Math.abs(calculated - 1.0f));
            if (calculated == 1.0f) {
                return Component.translatable((String)UNMODIFIED);
            }
            if (calculated < 1.0f) {
                return Component.translatable((String)REDUCED, (Object[])new Object[]{DSColors.dynamicValue(difference)});
            }
            return Component.translatable((String)INCREASED, (Object[])new Object[]{DSColors.dynamicValue(difference)});
        }
        int value = Math.abs((int)calculated);
        if (calculated == 0.0f) {
            return Component.translatable((String)UNMODIFIED);
        }
        MutableComponent mutableComponent = component = isTime ? Component.translatable((String)LangKey.SECONDS, (Object[])new Object[]{DSColors.dynamicValue(Functions.ticksToSeconds(value))}) : DSColors.dynamicValue(value);
        if (calculated < 0.0f) {
            return Component.translatable((String)REDUCED, (Object[])new Object[]{component});
        }
        return Component.translatable((String)INCREASED, (Object[])new Object[]{component});
    }

    @Override
    public Instance createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        return new Instance(this, CommonData.from(this.id(), dragon, ability, this.customIcon(), this.shouldRemoveAutomatically()), currentDuration);
    }

    @Override
    public AttachmentType<EffectModifications> type() {
        return (AttachmentType)DSDataAttachments.EFFECT_MODIFICATIONS.value();
    }

    public HolderSet<MobEffect> effects() {
        return this.effects;
    }

    public Modification durationModification() {
        return this.durationModification;
    }

    public Modification amplifierModification() {
        return this.amplifierModification;
    }

    public static class Instance
    extends DurationInstance<EffectModification> {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> DurationInstance.codecStart(instance, () -> CODEC).apply((Applicative)instance, Instance::new));

        public Instance(EffectModification baseData, CommonData commonData, int currentDuration) {
            super(baseData, commonData, currentDuration);
        }

        public int calculateDuration(int duration) {
            return switch (((EffectModification)this.baseData()).durationModification().type()) {
                default -> throw new MatchException(null, null);
                case Modification.ModificationType.ADDITIVE -> duration + (int)((EffectModification)this.baseData()).durationModification().amount().calculate(this.appliedAbilityLevel());
                case Modification.ModificationType.MULTIPLICATIVE -> (int)((float)duration * ((EffectModification)this.baseData()).durationModification().amount().calculate(this.appliedAbilityLevel()));
            };
        }

        public int calculateAmplifier(int amplifier) {
            return switch (((EffectModification)this.baseData()).amplifierModification().type()) {
                default -> throw new MatchException(null, null);
                case Modification.ModificationType.ADDITIVE -> amplifier + (int)((EffectModification)this.baseData()).amplifierModification().amount().calculate(this.appliedAbilityLevel());
                case Modification.ModificationType.MULTIPLICATIVE -> (int)((float)amplifier * ((EffectModification)this.baseData()).amplifierModification().amount().calculate(this.appliedAbilityLevel()));
            };
        }

        @Override
        public Component getDescription() {
            return ((EffectModification)this.baseData()).getDescription(this.appliedAbilityLevel());
        }

        @Override
        public void onAddedToStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncEffectModification(player.getId(), this, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @Override
        public void onRemovalFromStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncEffectModification(player.getId(), this, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Tag save(@NotNull HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }

        @Nullable
        public static Instance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
        }
    }
}

