/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Tiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LevelBasedTier(List<Entry> entries) {
    public static final Codec<LevelBasedTier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().xmap(list -> {
        ArrayList sorted = new ArrayList(list);
        Collections.sort(sorted);
        return sorted.reversed();
    }, Function.identity()).fieldOf("tiers").forGetter(LevelBasedTier::entries)).apply((Applicative)instance, LevelBasedTier::new));

    @Nullable
    public Tiers get(int level) {
        for (Entry entry : this.entries) {
            if (level < entry.fromLevel()) continue;
            return entry.tier();
        }
        return null;
    }

    public record Entry(Tiers tier, int fromLevel) implements Comparable<Entry>
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MiscCodecs.enumCodec(Tiers.class).fieldOf("tier").forGetter(Entry::tier), (App)ExtraCodecs.intRange((int)0, (int)255).fieldOf("from_level").forGetter(Entry::fromLevel)).apply((Applicative)instance, Entry::new));

        @Override
        public int compareTo(@NotNull Entry other) {
            if (this.fromLevel < other.fromLevel()) {
                return -1;
            }
            if (this.fromLevel > other.fromLevel()) {
                return 1;
            }
            return 0;
        }
    }
}

