/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record EntityCheckPredicate(Optional<Type> checkFor) implements EntitySubPredicate
{
    public static final MapCodec<EntityCheckPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Type.CODEC.optionalFieldOf("check_for").forGetter(EntityCheckPredicate::checkFor)).apply((Applicative)instance, EntityCheckPredicate::new));

    public boolean matches(@NotNull Entity entity, @NotNull ServerLevel level, @Nullable Vec3 position) {
        if (this.checkFor().isPresent()) {
            boolean isValid;
            switch (this.checkFor().get().ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    boolean bl = entity instanceof LivingEntity;
                    break;
                }
                case 1: {
                    boolean bl;
                    if (entity instanceof Enemy || entity.getType().getCategory() == MobCategory.MONSTER) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    TamableAnimal tamable;
                    boolean bl;
                    if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).isTame()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    boolean bl = entity instanceof Animal;
                    break;
                }
                case 4: {
                    boolean bl = entity instanceof ItemEntity;
                    break;
                }
                case 5: {
                    boolean bl = isValid = entity instanceof ExperienceOrb;
                }
            }
            if (!isValid) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public static enum Type implements StringRepresentable
    {
        LIVING_ENTITY("living_entity"),
        ENEMY("enemy"),
        TAMED("tamed"),
        ANIMAL("animal"),
        ITEM("item"),
        EXPERIENCE_ORB("experience_orb");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public static class Builder {
        private Optional<Type> type = Optional.empty();

        public static Builder start() {
            return new Builder();
        }

        public Builder type(Type type) {
            this.type = Optional.of(type);
            return this;
        }

        public Builder living() {
            this.type = Optional.of(Type.LIVING_ENTITY);
            return this;
        }

        public Builder enemy() {
            this.type = Optional.of(Type.ENEMY);
            return this;
        }

        public Builder tamed() {
            this.type = Optional.of(Type.TAMED);
            return this;
        }

        public Builder item() {
            this.type = Optional.of(Type.ITEM);
            return this;
        }

        public Builder experienceOrb() {
            this.type = Optional.of(Type.EXPERIENCE_ORB);
            return this;
        }

        public EntityCheckPredicate build() {
            return new EntityCheckPredicate(this.type);
        }
    }
}

