/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.effects;

import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.jetbrains.annotations.NotNull;

public class StressEffect
extends MobEffect {
    public static final int FULL_FOOD_LEVEL = 20;
    @ConfigRange(min=0.0)
    @Translation(key="stress_exhaustion", type=Translation.Type.CONFIGURATION, comments={"The amount of exhaustion applied every 20 ticks while stressed. Each amplifier level cuts the delay in half."})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "stress"}, key="stress_exhaustion")
    public static Float stressExhaustion = Float.valueOf(1.0f);

    public StressEffect(int color) {
        super(MobEffectCategory.HARMFUL, color);
    }

    public boolean applyEffectTick(@NotNull LivingEntity living, int amplifier) {
        if (living instanceof Player) {
            Player player = (Player)living;
            FoodData food = player.getFoodData();
            if (food.getSaturationLevel() > 0.0f) {
                int oldFood = food.getFoodLevel();
                food.eat(1, -0.5f * food.getSaturationLevel() * stressExhaustion.floatValue());
                if (oldFood < 20) {
                    food.setFoodLevel((int)((float)food.getFoodLevel() - 1.0f * stressExhaustion.floatValue()));
                }
            }
            player.causeFoodExhaustion(1.0f * stressExhaustion.floatValue());
            return true;
        }
        return false;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 20 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }
}

