/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.compat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;

public class ModCheck {
    public static final String JEI = "jei";
    public static final String IRIS = "iris";
    public static final String COSMETIC_ARMOR_REWORKED = "cosmeticarmorreworked";
    public static final String SOPHISTICATED_BACKPACKS = "sophisticatedbackpacks";
    public static final String CURIOS = "curios";
    public static final String CREATE = "create";
    public static final String FREECAM = "freecam";
    public static final String SILENTGEMS = "silentgems";
    public static final String EMI = "emi";
    private static final Map<String, List<String>> ALIAS = Map.of("iris", List.of("oculus"), "sodium", List.of("embeddium"));
    private static final Map<String, Boolean> MODS = new HashMap<String, Boolean>();

    public static boolean isModLoaded(String mod) {
        return MODS.computeIfAbsent(mod, key -> {
            if (ModCheck.check(key)) {
                return true;
            }
            for (String alias : ALIAS.getOrDefault(key, List.of())) {
                if (!ModCheck.check(alias)) continue;
                return true;
            }
            return false;
        });
    }

    private static boolean check(String modid) {
        ModList modList = ModList.get();
        if (modList != null && modList.isLoaded(modid)) {
            return true;
        }
        return LoadingModList.get().getModFileById(modid) != null;
    }
}

