/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.gametests;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.gametests.TestUtils;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.BuiltInDragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBodies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStages;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;

@PrefixGameTestTemplate(value=false)
@GameTestHolder(value="dragonsurvival")
public class GeneralTests {
    @GameTest(template="test_templates/1x1x1_air")
    public static void test_tool_swap(GameTestHelper helper) {
        Player player = TestUtils.createPlayer(helper);
        TestUtils.setToDragon(helper, player, BuiltInDragonSpecies.CAVE_DRAGON, DragonBodies.CENTER, DragonStages.young);
        ClawInventoryData clawInventory = ClawInventoryData.getData(player);
        ItemStack mainHandItem = Items.APPLE.getDefaultInstance();
        player.setItemInHand(InteractionHand.MAIN_HAND, mainHandItem);
        ItemStack clawItem = Items.STONE_PICKAXE.getDefaultInstance();
        clawInventory.set(ClawInventoryData.Slot.PICKAXE, clawItem);
        BlockState state = TestUtils.setBlock(helper, Blocks.IRON_ORE);
        DragonSurvival.LOGGER.info("Starting first tool swap layer");
        clawInventory.swapStart(player, state);
        GeneralTests.assertMainHandItem(helper, player, clawItem);
        GeneralTests.assertStoredItem(helper, player, mainHandItem);
        GeneralTests.assertClawItem(helper, player, ClawInventoryData.Slot.PICKAXE, ItemStack.EMPTY);
        DragonSurvival.LOGGER.info("Starting second tool swap layer");
        clawInventory.swapStart(player, state);
        GeneralTests.assertMainHandItem(helper, player, clawItem);
        GeneralTests.assertStoredItem(helper, player, mainHandItem);
        GeneralTests.assertClawItem(helper, player, ClawInventoryData.Slot.PICKAXE, ItemStack.EMPTY);
        DragonSurvival.LOGGER.info("Ending second tool swap layer");
        clawInventory.swapFinish(player);
        GeneralTests.assertMainHandItem(helper, player, clawItem);
        GeneralTests.assertStoredItem(helper, player, mainHandItem);
        GeneralTests.assertClawItem(helper, player, ClawInventoryData.Slot.PICKAXE, ItemStack.EMPTY);
        DragonSurvival.LOGGER.info("Ending first tool swap layer");
        clawInventory.swapFinish(player);
        GeneralTests.assertMainHandItem(helper, player, mainHandItem);
        GeneralTests.assertStoredItem(helper, player, ItemStack.EMPTY);
        GeneralTests.assertClawItem(helper, player, ClawInventoryData.Slot.PICKAXE, clawItem);
        helper.succeed();
    }

    public static void assertClawItem(GameTestHelper helper, Player player, ClawInventoryData.Slot slot, ItemStack item) {
        ClawInventoryData clawInventory = ClawInventoryData.getData(player);
        ItemStack clawItem = clawInventory.get(slot);
        helper.assertTrue(clawItem == item, String.format("Claw item for slot [%s] is [%s] - expected [%s]", new Object[]{slot, clawItem, item}));
    }

    public static void assertMainHandItem(GameTestHelper helper, Player player, ItemStack item) {
        ItemStack mainHandItem = player.getMainHandItem();
        helper.assertTrue(mainHandItem == item, String.format("Main hand item is [%s] - expected [%s]", mainHandItem, item));
    }

    public static void assertStoredItem(GameTestHelper helper, Player player, ItemStack item) {
        ClawInventoryData clawInventory = ClawInventoryData.getData(player);
        helper.assertTrue(clawInventory.storedMainHandTool == item, String.format("Stored item is [%s] - expected [%s]", clawInventory.storedMainHandTool, item));
    }
}

